/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.intro;

import com.modeliosoft.modelio.app.intro.ModelioScriptEngineManager;
import com.modeliosoft.modelio.app.intro.plugin.AppModelioIntro;
import com.modeliosoft.modelio.core.IModelingSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

class ModelioScriptEngineManager
extends ScriptEngineManager {
    private ScriptEngine jythonEngine = null;
    private File projectSpacePath;
    private File workspacePath;

    public ModelioScriptEngineManager(IModelingSession session, ClassLoader classLoader, File workspacePath, File projectSpacePath) {
        super(classLoader);
        this.workspacePath = workspacePath;
        this.projectSpacePath = projectSpacePath;
        this.put("modelingSession", (Object)session);
        this.put("classLoader", (Object)classLoader);
        this.put("SESSION", (Object)session);
        this.put("CLASSLOADER", (Object)classLoader);
    }

    public ScriptEngine getJythonEngine(ScriptEngine defaultEngine) throws JythonInitError {
        if (this.jythonEngine == null) {
            block17: {
                this.jythonEngine = defaultEngine != null ? defaultEngine : this.getEngineByName("python");
                if (this.jythonEngine == null) {
                    throw new JythonInitError("Jython engine not found.");
                }
                try {
                    Bundle bundle = Platform.getBundle((String)"org.modelio.core");
                    URL initFileUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("res/python/init.py"), null);
                    File initFilePath = new File(FileLocator.toFileURL((URL)initFileUrl).getPath());
                    if (initFilePath.isFile()) {
                        try {
                            Throwable throwable = null;
                            Object var6_10 = null;
                            try (FileReader reader = new FileReader(initFilePath);){
                                this.jythonEngine.eval(reader);
                                break block17;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (FileNotFoundException e) {
                            AppModelioIntro.LOG.error((Throwable)e);
                        }
                        catch (ScriptException e) {
                            AppModelioIntro.LOG.error((Throwable)e);
                        }
                        break block17;
                    }
                    AppModelioIntro.LOG.error("'" + initFilePath.toString() + "' not found, Modelio API won't be accessible from Jython.");
                }
                catch (IOException e) {
                    AppModelioIntro.LOG.error((Throwable)e);
                }
            }
            File wsRc = new File(this.workspacePath, "rc.py");
            this.evalFile(wsRc);
            File prjRc = new File(this.projectSpacePath, "rc.py");
            this.evalFile(prjRc);
        }
        return this.jythonEngine;
    }

    private void evalFile(File jythonFile) {
        if (jythonFile.isFile()) {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (FileReader reader = new FileReader(jythonFile);){
                    this.jythonEngine.eval(reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                AppModelioIntro.LOG.error((Throwable)e);
            }
            catch (IOException e) {
                AppModelioIntro.LOG.error((Throwable)e);
            }
            catch (ScriptException e) {
                AppModelioIntro.LOG.error((Throwable)e);
            }
        }
    }

    private void logFoundScriptEngines(PrintStream out) {
        out.println("--------------------------------------------");
        out.println("Listing all script engines :");
        List factories = this.getEngineFactories();
        for (ScriptEngineFactory aFactory : factories) {
            out.print(" * ");
            try {
                String engName = aFactory.getEngineName();
                String engVersion = aFactory.getEngineVersion();
                String langName = aFactory.getLanguageName();
                String langVersion = aFactory.getLanguageVersion();
                out.printf("Script Engine: %s (%s)\n", engName, engVersion);
                out.printf("\tLanguage: %s (%s)\n", langName, langVersion);
                List<String> engNames = aFactory.getNames();
                for (String name : engNames) {
                    out.printf("\tAlias: %s\n", name);
                }
                for (String ext : aFactory.getExtensions()) {
                    out.printf("\tExtension: %s\n", ext);
                }
            }
            catch (Exception e) {
                out.printf("\t ERROR: %s\n\n", e.toString());
            }
            catch (LinkageError e) {
                out.printf("\t ERROR: %s\n\n", e.toString());
            }
            out.println();
        }
        out.println("--------------------------------------------");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logFoundScriptEngines() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream ss = new ByteArrayOutputStream();){
                Throwable throwable2 = null;
                Object var5_9 = null;
                try (PrintStream out = new PrintStream(ss);){
                    this.logFoundScriptEngines(out);
                    AppModelioIntro.LOG.info(((Object)ss).toString());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            AppModelioIntro.LOG.error((Throwable)e);
        }
    }
}

