/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.intro;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.app.intro.ModelioScriptEngineManager;
import com.modeliosoft.modelio.app.intro.ScriptClassLoader;
import com.modeliosoft.modelio.app.intro.plugin.AppModelioIntro;
import com.modeliosoft.modelio.core.IModelingSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

class ScriptRunner {
    private final IModelingSession session;
    private final File workspacePath;
    private final File projectSpacePath;

    public ScriptRunner(IModelingSession session, File workspacePath, File projectSpacePath) {
        this.session = session;
        this.workspacePath = workspacePath;
        this.projectSpacePath = projectSpacePath;
    }

    public void runScript(File scriptFile) {
        ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
        this.addPluginsClassLoaders(parents);
        Collection mdacs = this.session.getMdacRegistry().getStartedMdacs();
        for (IMdac mdac : mdacs) {
            parents.add(mdac.getClass().getClassLoader());
        }
        ScriptClassLoader classLoader = new ScriptClassLoader(parents);
        ModelioScriptEngineManager m = new ModelioScriptEngineManager(this.session, (ClassLoader)classLoader, this.workspacePath, this.projectSpacePath);
        String fileName = scriptFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        ScriptEngine engine = extension.equals("py") ? m.getJythonEngine(null) : m.getEngineByExtension(extension);
        if (engine == null) {
            AppModelioIntro.LOG.error("No script engine found for '." + extension + "' extension.");
            return;
        }
        AppModelioIntro.LOG.info("Running '" + scriptFile.getPath() + "' script...\n");
        try {
            engine.eval(new FileReader(scriptFile));
        }
        catch (FileNotFoundException e) {
            AppModelioIntro.LOG.error("File not found :" + scriptFile.getPath());
            AppModelioIntro.LOG.error(e.getLocalizedMessage());
        }
        catch (ScriptException e) {
            AppModelioIntro.LOG.error(e.getLocalizedMessage());
            AppModelioIntro.LOG.error((Throwable)e);
        }
        catch (RuntimeException e) {
            AppModelioIntro.LOG.error((Throwable)e);
        }
    }

    private void addPluginClassLoader(List<ClassLoader> parentLoaders, String pluginId, String className) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            try {
                Class clazz = bundle.loadClass(className);
                ClassLoader loader = clazz.getClassLoader();
                parentLoaders.add(loader);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            AppModelioIntro.LOG.error(" '" + pluginId + "' plugin not found.");
        }
    }

    private void addPluginsClassLoaders(List<ClassLoader> parentLoaders) {
        this.addPluginClassLoader(parentLoaders, "org.modelio.modelapi", "com.modeliosoft.modelio.api.model.uml.statik.IPackage");
        this.addPluginClassLoader(parentLoaders, "org.modelio.ramcs", "com.modeliosoft.modelio.ramcs.plugin.Ramcs");
        this.addPluginClassLoader(parentLoaders, "org.modelio.script", "com.modeliosoft.modelio.script.plugin.ScriptSession");
    }
}

