/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject;

import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class BpmnDataFigure
extends GradientFigure {
    private static final PointList foldTemplate;
    private static final int FOLDSIZE = 12;
    protected Figure iconsArea;
    protected Figure iconsContainer;
    protected Figure botomContainer;

    static {
        int[] nArray = new int[6];
        nArray[3] = 12;
        nArray[4] = 12;
        nArray[5] = 12;
        foldTemplate = new PointList(nArray);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle aBounds = this.getBounds().getCopy();
        Rectangle originalClip = new Rectangle();
        graphics.getClip(originalClip);
        if (this.isOpaque()) {
            Path path = new Path((Device)Display.getCurrent());
            Rectangle r1 = new Rectangle(aBounds.x, aBounds.y, aBounds.width - 12, aBounds.height);
            Rectangle r2 = new Rectangle(aBounds.x + aBounds.width - 12, aBounds.y + 12, 12, aBounds.height);
            path.addRectangle((float)r1.x, (float)r1.y, (float)r1.width, (float)r1.height);
            path.addRectangle((float)r2.x, (float)r2.y, (float)r2.width, (float)r2.height);
            graphics.setClip(path);
            super.paintFigure(graphics);
            path.dispose();
            graphics.setClip(originalClip);
            PointList polygon = foldTemplate.getCopy();
            polygon.translate(aBounds.x + aBounds.width - 12, aBounds.y);
            graphics.fillPolygon(polygon);
        }
        if (this.penOptions.lineWidth % 2 == 1) {
            --aBounds.width;
            --aBounds.height;
        }
        aBounds.shrink(this.penOptions.lineWidth / 2, this.penOptions.lineWidth / 2);
        graphics.setLineWidth(this.penOptions.lineWidth);
        graphics.setForegroundColor(this.penOptions.lineColor);
        Point p1 = new Point(aBounds.x + aBounds.width - 12, aBounds.y);
        Point p2 = new Point(aBounds.x + aBounds.width - 12, aBounds.y + 12);
        Point p3 = new Point(aBounds.x + aBounds.width, aBounds.y + 12);
        graphics.drawLine(aBounds.getTopLeft(), aBounds.getBottomLeft());
        graphics.drawLine(aBounds.getBottomLeft(), aBounds.getBottomRight());
        graphics.drawLine(aBounds.getBottomRight(), p3);
        graphics.drawLine(p3, p1);
        graphics.drawLine(p1, aBounds.getTopLeft());
        graphics.drawLine(p3, p2);
        graphics.drawLine(p2, p1);
        graphics.setLineStyle(3);
    }

    public BpmnDataFigure() {
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.iconsArea = new Figure();
        this.iconsArea.setLayoutManager((LayoutManager)new BorderLayout());
        this.add((IFigure)this.iconsArea, (Object)BorderLayout.CENTER);
        this.iconsContainer = new Figure();
        BorderLayout centerIconAreaLayout = new BorderLayout();
        this.iconsContainer.setLayoutManager((LayoutManager)centerIconAreaLayout);
        this.iconsContainer.setOpaque(false);
        this.iconsArea.add((IFigure)this.iconsContainer, (Object)BorderLayout.CENTER);
        this.botomContainer = new Figure();
        BorderLayout botomIconAreaLayout = new BorderLayout();
        this.botomContainer.setLayoutManager((LayoutManager)botomIconAreaLayout);
        this.botomContainer.setOpaque(false);
        this.iconsArea.add((IFigure)this.botomContainer, (Object)BorderLayout.TOP);
    }

    public void setCenterIcone(List<Image> icons) {
        this.iconsContainer.removeAll();
        for (Image img : icons) {
            ImageFigure imgFigure = new ImageFigure(img);
            this.iconsContainer.add((IFigure)imgFigure, (Object)BorderLayout.CENTER);
        }
    }

    public void setTopIcone(List<Image> icons) {
        this.botomContainer.removeAll();
        for (Image img : icons) {
            ImageFigure imgFigure = new ImageFigure(img);
            imgFigure.setBorder((Border)new MarginBorder(5, 5, 0, 0));
            this.botomContainer.add((IFigure)imgFigure, (Object)BorderLayout.LEFT);
        }
    }
}

