/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataAssociation;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataObject;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowNode;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemAwareElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlowDataAssociation;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnsequenceflow.GmBpmnSequenceFlow;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import org.eclipse.gef.commands.Command;

public class CreateBpmnDataObjectCommand
extends Command {
    private GmBpmnSequenceFlow parentNode;
    private ModelioCreationContext context;
    private IBpmnSequenceFlow parentElement;

    public CreateBpmnDataObjectCommand(IBpmnSequenceFlow sequenceFlow, GmBpmnSequenceFlow gm, ModelioCreationContext context) {
        this.parentNode = gm;
        this.parentElement = sequenceFlow;
        this.context = context;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IModelFactory modelFactory = diagram.getModelFactory();
        IBpmnDataObject newElement = (IBpmnDataObject)modelFactory.createElement("BpmnDataObject");
        IElement owner = this.getOwnerProcess(this.parentElement.getCompositionOwner());
        if (owner instanceof IBpmnProcess) {
            newElement.setContainer((IBpmnProcess)owner);
        } else if (owner instanceof IBpmnSubProcess) {
            newElement.setSubProcess((IBpmnSubProcess)owner);
        }
        IBpmnFlowNode source = this.parentElement.getSourceRef();
        IBpmnFlowNode target = this.parentElement.getTargetRef();
        IBpmnDataAssociation sourceAssociation = (IBpmnDataAssociation)modelFactory.createElement("BpmnDataAssociation");
        sourceAssociation.setStartingActivity((IBpmnActivity)source);
        sourceAssociation.setTargetRef((IBpmnItemAwareElement)newElement);
        IBpmnDataAssociation targetAssociation = (IBpmnDataAssociation)modelFactory.createElement("BpmnDataAssociation");
        targetAssociation.setEndingActivity((IBpmnActivity)target);
        targetAssociation.addSourceRef((IBpmnItemAwareElement)newElement);
        IBpmnSequenceFlowDataAssociation sequenceFlowAssociation = (IBpmnSequenceFlowDataAssociation)modelFactory.createElement("BpmnSequenceFlowDataAssociation");
        sequenceFlowAssociation.setConnected(this.parentElement);
        sequenceFlowAssociation.addDataAssociation(sourceAssociation);
        sequenceFlowAssociation.addDataAssociation(targetAssociation);
        DefaultNameFactory.setDefaultName((IModelElement)newElement);
        if (this.context.getStereotype() != null) {
            newElement.addExtension(this.context.getStereotype());
        }
    }

    private IElement getOwnerProcess(IElement element) {
        if (element instanceof IBpmnProcess || element instanceof IBpmnSubProcess) {
            return element;
        }
        return this.getOwnerProcess(element.getCompositionOwner());
    }
}

