/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemAwareElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemDefinition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.modelelement.GmModelElementFlatHeader;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;

public class GmBpmnDataLabel
extends GmModelElementFlatHeader {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmBpmnDataLabel(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public GmBpmnDataLabel() {
    }

    public List<IStereotype> filterStereotypes(List<IStereotype> stereotypes) {
        StyleKey key = this.getStyleKey(MetaKey.REPMODE);
        if (key != null && this.getStyle().getProperty(key) == StyleKey.RepresentationMode.IMAGE) {
            for (IStereotype stereo : stereotypes) {
                if (stereo.getIcon().isEmpty()) continue;
                ArrayList<IStereotype> ret = new ArrayList<IStereotype>(stereotypes);
                ret.remove(stereo);
                return ret;
            }
        }
        return stereotypes;
    }

    public List<ITaggedValue> filterTags(List<ITaggedValue> taggedValues) {
        return taggedValues;
    }

    public IEditableText getEditableText() {
        if (this.getRelatedIElement() == null) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean isVisible() {
        StyleKey key = this.getParent().getStyleKey(MetaKey.SHOWLABEL);
        if (key == null) {
            return true;
        }
        return (Boolean)this.getStyle().getProperty(key);
    }

    protected String computeLabel() {
        IBpmnItemAwareElement element;
        String mlabel = null;
        String reference = null;
        if (this.getRelatedIElement() != null && !this.getRelatedIElement().getName().equals("")) {
            mlabel = this.getRelatedIElement().getName();
        }
        if ((element = (IBpmnItemAwareElement)this.getRelatedIElement()).getRepresentedAttribute() != null) {
            reference = element.getRepresentedAttribute().getName();
        } else if (element.getRepresentedInstance() != null) {
            reference = element.getRepresentedInstance().getName();
        } else if (element.getRepresentedAssociationEnd() != null) {
            reference = element.getRepresentedAssociationEnd().getName();
        } else if (element.getRepresentedAssociationEnd() != null) {
            reference = element.getRepresentedAssociationEnd().getName();
        } else if (element.getType() != null) {
            reference = element.getType().getName();
        } else if (element.getInState() != null) {
            reference = element.getInState().getName();
        } else if (element.getItemSubjectRef() != null) {
            IBpmnItemDefinition item = element.getItemSubjectRef();
            reference = item.getStructureRef() != null ? item.getStructureRef().getName() : item.getName();
        }
        StringBuilder s = new StringBuilder();
        String basename = DefaultNameFactory.getBaseName((IModelElement)element);
        if (!(mlabel == null || mlabel.equals("") || mlabel.startsWith(basename) && reference != null)) {
            s.append(mlabel);
            if (reference != null) {
                s.append(":");
            }
        }
        if (reference != null) {
            s.append(reference);
        }
        return s.toString();
    }

    public void styleChanged(IStyle changedStyle) {
        this.fireVisibilityChanged();
        super.styleChanged(changedStyle);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        StyleKey key = this.getParent().getStyleKey(MetaKey.SHOWLABEL);
        if (key != null && key.equals((Object)property)) {
            this.fireVisibilityChanged();
        } else {
            super.styleChanged(property, newValue);
        }
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmBpmnDataLabel.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmBpmnDataLabel.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

