/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject.datainput;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataInput;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemDefinition;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject.GmBpmnDataLabel;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject.GmBpmnDataObjectStyleKeys;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;

public class GmBpmnDataInputLabel
extends GmBpmnDataLabel {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmBpmnDataInputLabel(GmAbstractDiagram diagram, ObRef ref) {
        super(diagram, ref);
    }

    protected String computeLabel() {
        IBpmnDataInput element;
        String mlabel = null;
        String reference = null;
        if (this.getRelatedIElement() != null && !this.getRelatedIElement().getName().equals("")) {
            mlabel = this.getRelatedIElement().getName();
        }
        if ((element = (IBpmnDataInput)this.getRelatedIElement()).getRepresentedAttribute() != null) {
            reference = element.getRepresentedAttribute().getName();
        } else if (element.getRepresentedInstance() != null) {
            reference = element.getRepresentedInstance().getName();
        } else if (element.getRepresentedAssociationEnd() != null) {
            reference = element.getRepresentedAssociationEnd().getName();
        } else if (element.getRepresentedParameter() != null) {
            reference = element.getRepresentedParameter().getName();
        } else if (element.getType() != null) {
            reference = element.getType().getName();
        } else if (element.getInState() != null) {
            reference = element.getInState().getName();
        } else if (element.getItemSubjectRef() != null) {
            IBpmnItemDefinition item = element.getItemSubjectRef();
            reference = item.getStructureRef() != null ? item.getStructureRef().getName() : item.getName();
        }
        StringBuilder s = new StringBuilder();
        Boolean showrepresented = (Boolean)this.getStyle().getProperty(GmBpmnDataObjectStyleKeys.SHOWREPRESENTED);
        if (!showrepresented.booleanValue()) {
            if (reference != null) {
                s.append(reference);
            } else if (mlabel != null) {
                s.append(mlabel);
            }
        } else {
            if (mlabel != null) {
                s.append(mlabel);
                if (reference != null) {
                    s.append(" : ");
                }
            }
            if (reference != null) {
                s.append(reference);
            }
        }
        return s.toString();
    }

    public GmBpmnDataInputLabel() {
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmBpmnDataInputLabel.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmBpmnDataInputLabel.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

