/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlanesetcontainer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class BpmnLaneSetContainerLayout
extends ToolbarLayout {
    private Map<IFigure, Integer> constraints = new HashMap();

    protected Dimension getChildPreferredSize(IFigure child, int wHint, int hHint) {
        int height = hHint;
        Integer constraint = (Integer)this.constraints.get(child);
        if (constraint == null || constraint == -1) {
            Dimension childPrefSize = child.getPreferredSize(wHint, hHint);
            constraint = childPrefSize.width;
            height = childPrefSize.height;
        }
        return new Dimension(height, constraint.intValue());
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
        if (constraint != null && constraint instanceof Integer) {
            this.constraints.put(child, (Integer)constraint);
        }
    }

    public void layout(IFigure parent) {
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        int totalHeight = 0;
        int totalMinHeight = 0;
        int prefMinSumHeight = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(this.getChildPreferredSize(child, wHint, hHint));
            minSizes[i] = this.transposer.t(this.getChildMinimumSize(child, wHint, hHint));
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            ++i;
        }
        prefMinSumHeight = (totalHeight += (numChildren - 1) * this.spacing) - (totalMinHeight += (numChildren - 1) * this.spacing);
        int amntShrinkHeight = totalHeight - availableHeight;
        if (amntShrinkHeight < 0) {
            if (prefSizes.length > 0) {
                prefSizes[prefSizes.length - 1].height -= amntShrinkHeight;
            }
            amntShrinkHeight = 0;
        }
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            int prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = 0;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (prefMinSumHeight != 0) {
                amntShrinkCurrentHeight = (prefHeight - minHeight) * amntShrinkHeight / prefMinSumHeight;
            }
            int width = Math.min(prefWidth, this.transposer.t((Dimension)child.getMaximumSize()).width);
            if (this.matchWidth) {
                width = this.transposer.t((Dimension)child.getMaximumSize()).width;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.minorAlignment) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            y += newBounds.height + this.spacing;
            ++i2;
        }
    }
}

