/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlanesetcontainer;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlane.BpmnLaneEditPart;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlanesetcontainer.BpmnLaneSetContainerLayout;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlanesetcontainer.GmBpmnLaneSetContainer;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlanesetcontainer.ReorderChildrenCommand;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlanesetcontainer.ResizePartitionsCommand;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.policies.BpmnLaneReparentElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultReparentElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultNodeResizableEditPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;

public class BpmnLaneSetContainerLayoutEditPolicy
extends OrderedLayoutEditPolicy {
    private Polyline insertionLine;
    private static final Dimension DEFAULT_SIZE = new Dimension(-1, -1);

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        if (child instanceof GmNodeEditPart) {
            GmNodeModel reference = null;
            if (after != null) {
                reference = (GmNodeModel)after.getModel();
            }
            ReorderChildrenCommand command = new ReorderChildrenCommand(this.getHostCompositeNode(), (GmNodeModel)child.getModel(), reference);
            return command;
        }
        return null;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        GmNodeModel gmmodel = (GmNodeModel)child.getModel();
        IElement element = gmmodel.getRelatedIElement();
        if (element instanceof IBpmnLane) {
            return new BpmnLaneReparentElementCommand(this.getHostElement(), this.getHostCompositeNode(), (GmNodeModel)child.getModel(), ((GmNodeModel)child.getModel()).getLayoutData());
        }
        GmNodeModel reference = null;
        if (after != null) {
            reference = (GmNodeModel)after.getModel();
        }
        CompoundCommand compound = new CompoundCommand();
        compound.add((Command)new DefaultReparentElementCommand(this.getHostElement(), this.getHostCompositeNode(), (GmNodeModel)child.getModel(), ((GmNodeModel)child.getModel()).getLayoutData()));
        compound.add((Command)new ReorderChildrenCommand(this.getHostCompositeNode(), (GmNodeModel)child.getModel(), reference));
        return compound;
    }

    private GmCompositeNode getHostCompositeNode() {
        return (GmCompositeNode)this.getHost().getModel();
    }

    protected IElement getHostElement() {
        IElement hostElement = this.getHostCompositeNode().getRelatedIElement();
        if (hostElement instanceof IAbstractDiagram) {
            hostElement = ((IAbstractDiagram)hostElement).getOrigin();
        }
        return hostElement;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("create child".equals(request.getType())) {
            return null;
        }
        if ("add children".equals(request.getType()) || "clone".equals(request.getType()) || "move".equals(request.getType())) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            return this.getTargetEditPart(changeBoundsRequest);
        }
        return null;
    }

    private EditPart getTargetEditPart(ChangeBoundsRequest changeBoundsRequest) {
        for (Object editPartObj : changeBoundsRequest.getEditParts()) {
            EditPart editPart = (EditPart)editPartObj;
            if (!(editPart.getModel() instanceof GmModel)) continue;
            GmModel gmModel = (GmModel)editPart.getModel();
            String metaclassName = gmModel.getRepresentedRef().mc;
            if (this.canHandle(MetaModelExpert.getMetaclass((String)metaclassName)) || editPart instanceof ConnectionEditPart) continue;
            return null;
        }
        return this.getHost();
    }

    protected boolean canHandle(Class<? extends IElement> metaclass) {
        Class<?> hostMetaclass = this.getHostElement().getClass();
        boolean returnCommand = CreationExpertRegistry.getExpert(hostMetaclass).canOwn(metaclass);
        return returnCommand && ((GmCompositeNode)this.getHost().getModel()).canCreate(metaclass);
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.insertionLine != null) {
            this.removeFeedback((IFigure)this.insertionLine);
            this.insertionLine = null;
        }
    }

    private Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected int getFeedbackIndexFor(Request request) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(true);
        Point p = transposer.t(this.getLocationFromRequest(request));
        int rowBottom = Integer.MIN_VALUE;
        int candidate = -1;
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            Rectangle rect = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)child));
            if (rect.y > rowBottom) {
                if (p.y <= rowBottom) {
                    if (candidate != -1) break;
                    candidate = i;
                    break;
                }
                candidate = -1;
            }
            rowBottom = Math.max(rowBottom, rect.bottom());
            if (candidate == -1 && p.x <= rect.x + rect.width / 2) {
                candidate = i;
            }
            if (candidate != -1 && p.y <= rowBottom) break;
            ++i;
        }
        return candidate;
    }

    protected EditPart getInsertionReference(Request request) {
        List children = this.getHost().getChildren();
        if (request.getType().equals("create child")) {
            int i = this.getFeedbackIndexFor(request);
            if (i == -1) {
                return null;
            }
            return (EditPart)children.get(i);
        }
        int index = this.getFeedbackIndexFor(request);
        if (index != -1) {
            List selection = this.getHost().getViewer().getSelectedEditParts();
            do {
                EditPart editpart;
                if (selection.contains(editpart = (EditPart)children.get(index))) continue;
                return editpart;
            } while (++index < children.size());
        }
        return null;
    }

    protected Polyline getLineFeedback() {
        if (this.insertionLine == null) {
            this.insertionLine = new Polyline();
            this.insertionLine.setForegroundColor(ColorConstants.green);
            this.insertionLine.setLineWidth(3);
            this.insertionLine.addPoint(new Point(-5, 0));
            this.insertionLine.addPoint(new Point(5, 0));
            this.insertionLine.addPoint(new Point(0, 0));
            this.insertionLine.addPoint(new Point(10, 10));
            this.addFeedback((IFigure)this.insertionLine);
        }
        return this.insertionLine;
    }

    private Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    protected boolean isHorizontal() {
        return true;
    }

    protected void showLayoutTargetFeedback(Request request) {
        Rectangle parentBox;
        EditPart editPart;
        Transposer transposer;
        Polyline fb;
        Command command = this.getCommand(request);
        if (!("move".equals(request.getType()) || command != null && command.canExecute())) {
            return;
        }
        ArrayList partitionChildren = new ArrayList(this.getHost().getChildren());
        for (Object child : this.getHost().getChildren()) {
            if (child instanceof BpmnLaneEditPart) continue;
            partitionChildren.remove(child);
        }
        if (partitionChildren.size() == 0) {
            fb = this.getLineFeedback();
            transposer = new Transposer();
            transposer.setEnabled(true);
            Rectangle r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
            Point p1 = new Point(r.x + r.width / 2, r.y - 4);
            p1 = transposer.t(p1);
            fb.translateToRelative((Translatable)p1);
            Point p2 = new Point(r.x + r.width / 2, r.y + r.height + 4);
            p2 = transposer.t(p2);
            fb.translateToRelative((Translatable)p2);
            fb.setPoint(p1, 0);
            fb.setPoint(p1, 1);
            fb.setPoint(p2, 2);
            fb.setPoint(p2, 3);
            return;
        }
        fb = this.getLineFeedback();
        transposer = new Transposer();
        transposer.setEnabled(true);
        boolean before = true;
        int epIndex = this.getFeedbackIndexFor(request);
        Rectangle r = null;
        if (epIndex == -1) {
            before = false;
            epIndex = partitionChildren.size() - 1;
            editPart = (EditPart)partitionChildren.get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
        } else {
            editPart = (EditPart)partitionChildren.get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            Point p = transposer.t(this.getLocationFromRequest(request));
            if (p.x <= r.x + r.width / 2) {
                before = true;
            } else {
                before = false;
                editPart = (EditPart)partitionChildren.get(--epIndex);
                r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            }
        }
        int x = Integer.MIN_VALUE;
        if (before) {
            if (epIndex > 0) {
                Rectangle boxPrev = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)partitionChildren.get(epIndex - 1)));
                int prevRight = boxPrev.right();
                if (prevRight < r.x - ((BpmnLaneSetContainerLayout)this.getHostFigure().getLayoutManager()).getSpacing()) {
                    x = prevRight + (r.x - prevRight) / 2;
                } else if (prevRight == r.x - ((BpmnLaneSetContainerLayout)this.getHostFigure().getLayoutManager()).getSpacing()) {
                    x = prevRight + 1;
                }
            }
            if (x == Integer.MIN_VALUE) {
                parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
                x = r.x - 5;
                if (x < parentBox.x) {
                    x = parentBox.x + (r.x - parentBox.x) / 2;
                }
            }
        } else {
            parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
            int rRight = r.x + r.width;
            x = rRight + 5;
            int pRight = parentBox.x + parentBox.width;
            if (x > pRight) {
                x = rRight + (pRight - rRight) / 2;
            }
        }
        Point header1 = new Point(x - 10, r.y - 4);
        header1 = transposer.t(header1);
        fb.translateToRelative((Translatable)header1);
        Point header2 = new Point(x + 10, r.y - 4);
        header2 = transposer.t(header2);
        fb.translateToRelative((Translatable)header2);
        Point p1 = new Point(x, r.y - 4);
        p1 = transposer.t(p1);
        fb.translateToRelative((Translatable)p1);
        Point p2 = new Point(x, r.y + r.height + 4);
        p2 = transposer.t(p2);
        fb.translateToRelative((Translatable)p2);
        fb.setPoint(header1, 0);
        fb.setPoint(header2, 1);
        fb.setPoint(p1, 2);
        fb.setPoint(p2, 3);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        GmNodeEditPart childNode;
        SelectionEditPolicy childPolicy;
        if (child instanceof GmNodeEditPart && (childPolicy = (childNode = (GmNodeEditPart)child).getPreferredDragRolePolicy("resize")) != null) {
            return childPolicy;
        }
        return new DefaultNodeResizableEditPolicy();
    }

    protected Command getMoveChildrenCommand(Request request) {
        List editParts = ((ChangeBoundsRequest)request).getEditParts();
        CompoundCommand command = new CompoundCommand();
        EditPart insertionReference = this.getInsertionReference(request);
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createMoveChildCommand(child, insertionReference));
            ++i;
        }
        return command.unwrap();
    }

    protected Rectangle getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        PrecisionRectangle rect = new PrecisionRectangle(child.getFigure().getBounds());
        Rectangle original = rect.getCopy();
        child.getFigure().translateToAbsolute((Translatable)rect);
        rect = request.getTransformedRectangle((Rectangle)rect);
        child.getFigure().translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutContainer().getClientArea().getLocation().getNegated());
        if (request.getSizeDelta().width == 0 && request.getSizeDelta().height == 0) {
            Rectangle cons = this.getCurrentConstraintFor(child);
            if (cons != null) {
                rect.setSize(cons.width, cons.height);
            }
        } else {
            Dimension minSize = this.getMinimumSizeFor(child);
            if (rect.width < minSize.width) {
                rect.width = minSize.width;
                if (rect.x > original.right() - minSize.width) {
                    rect.x = original.right() - minSize.width;
                }
            }
            if (rect.height < minSize.height) {
                rect.height = minSize.height;
                if (rect.y > original.bottom() - minSize.height) {
                    rect.y = original.bottom() - minSize.height;
                }
            }
        }
        return this.getConstraintFor((Rectangle)rect);
    }

    public Rectangle getConstraintFor(Point p) {
        return new Rectangle(p, DEFAULT_SIZE);
    }

    public Rectangle getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        return (Rectangle)fig.getParent().getLayoutManager().getConstraint(fig);
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        return child.getFigure().getMinimumSize();
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand compound = new CompoundCommand();
        ResizePartitionsCommand command = new ResizePartitionsCommand((GmBpmnLaneSetContainer)this.getHost().getModel());
        List resizedEditParts = request.getEditParts();
        HashMap<GmNodeModel, Integer> newConstraints = new HashMap<GmNodeModel, Integer>();
        int i = 0;
        while (i < resizedEditParts.size()) {
            GraphicalEditPart resizedChild = (GraphicalEditPart)resizedEditParts.get(i);
            Dimension constraint = this.getConstraintFor(request, resizedChild).getSize();
            newConstraints.put((GmNodeModel)resizedChild.getModel(), constraint.height);
            GraphicalEditPart impactedNeighbour = this.getImpactedNeighbour(resizedChild, request);
            if (impactedNeighbour != null) {
                ChangeBoundsRequest inverseRequest = new ChangeBoundsRequest((Object)"resize");
                inverseRequest.setEditParts((EditPart)impactedNeighbour);
                inverseRequest.setLocation(request.getLocation());
                inverseRequest.setSizeDelta(request.getSizeDelta().getNegated());
                inverseRequest.setResizeDirection(request.getResizeDirection());
                Dimension neighbourConstraint = this.getConstraintFor(inverseRequest, impactedNeighbour).getSize();
                newConstraints.put((GmNodeModel)impactedNeighbour.getModel(), neighbourConstraint.height);
            } else {
                ChangeBoundsRequest resizeContainerRequest = new ChangeBoundsRequest((Object)"resize");
                resizeContainerRequest.setEditParts(this.getHost().getParent());
                resizeContainerRequest.setLocation(request.getLocation());
                resizeContainerRequest.setResizeDirection(request.getResizeDirection());
                Dimension sizeDelta = request.getSizeDelta().getCopy();
                sizeDelta.width = 0;
                resizeContainerRequest.setSizeDelta(sizeDelta);
                Command parentCommand = this.getHost().getParent().getParent().getCommand((Request)resizeContainerRequest);
                compound.add(parentCommand);
            }
            ++i;
        }
        command.setNewConstraints(newConstraints);
        compound.add((Command)command);
        return compound;
    }

    protected Rectangle getConstraintFor(CreateRequest request) {
        IFigure figure = this.getLayoutContainer();
        Point where = request.getLocation().getCopy();
        Dimension size = request.getSize();
        figure.translateToRelative((Translatable)where);
        figure.translateFromParent((Translatable)where);
        where.translate(this.getLayoutContainer().getClientArea().getLocation().getNegated());
        if (size == null || size.isEmpty()) {
            return this.getConstraintFor(where);
        }
        size = size.getCopy();
        figure.translateToRelative((Translatable)size);
        figure.translateFromParent((Translatable)size);
        return this.getConstraintFor(new Rectangle(where, size));
    }

    private GraphicalEditPart getImpactedNeighbour(GraphicalEditPart resizedChild, ChangeBoundsRequest request) {
        GraphicalEditPart previousChild = null;
        ArrayList<GraphicalEditPart> nextChildren = new ArrayList<GraphicalEditPart>(this.getHost().getChildren().size());
        for (Object childObj : this.getHost().getChildren()) {
            nextChildren.add((GraphicalEditPart)childObj);
        }
        nextChildren.removeAll(request.getEditParts());
        nextChildren.add(null);
        for (Object childObj : this.getHost().getChildren()) {
            GraphicalEditPart child = (GraphicalEditPart)childObj;
            if (child.equals(resizedChild)) {
                if ((request.getResizeDirection() & 0x10) != 0 || (request.getResizeDirection() & 4) != 0) {
                    if (child.equals(nextChildren.get(0))) {
                        return (GraphicalEditPart)nextChildren.get(1);
                    }
                    return (GraphicalEditPart)nextChildren.get(0);
                }
                if ((request.getResizeDirection() & 8) != 0 || (request.getResizeDirection() & 1) != 0) {
                    return previousChild;
                }
                return null;
            }
            if (!child.equals(nextChildren.get(0))) continue;
            nextChildren.remove(0);
            previousChild = child;
        }
        throw new IllegalArgumentException("argument edit part is not a child of current container");
    }

    protected Command getAddCommand(Request req) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            if (child instanceof ConnectionEditPart) {
                command.add(child.getCommand(req));
            } else {
                command.add(this.createAddCommand(child, this.getInsertionReference((Request)request)));
            }
            ++i;
        }
        return command.unwrap();
    }
}

