/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnlinkedobject;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnCatchEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataAssociation;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataOutput;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemAwareElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnThrowEvent;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.CreateLinkedNodeCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.link.GmAbstractLinkAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmLinkAnchor;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class BpmnLinkedObjectCommand
extends CreateLinkedNodeCommand {
    private Point location;
    private Dimension size = new Dimension(-1, -1);
    private Dimension sourceAnchorLocation;
    private ModelioCreationContext context;
    private GmNodeModel sourceNode;
    private GmCompositeNode destNode;
    private IElement parentElement;

    public BpmnLinkedObjectCommand(ModelioCreationContext context) {
        super(context);
        this.context = context;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.sourceNode.getDiagram();
        IBpmnItemAwareElement newElement = (IBpmnItemAwareElement)this.context.getElementToUnmask();
        ArrayList<IBpmnDataAssociation> dataAssociation = new ArrayList<IBpmnDataAssociation>();
        if (newElement == null) {
            IBpmnActivity owner;
            IModelFactory modelFactory = diagram.getModelFactory();
            newElement = (IBpmnItemAwareElement)modelFactory.createElement(this.context.getMetaclass());
            Meta meta = new Meta(this.parentElement);
            try {
                meta.appendToDependency(this.context.getDependency(), (IElement)newElement);
            }
            catch (InvalidModelManipulationException e) {
                String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
                if (compositionDep != null && !compositionDep.equals("")) {
                    meta.appendToDependency(compositionDep, (IElement)newElement);
                }
                modelFactory.deleteElement((IElement)newElement);
                return;
            }
            if (this.context.getStereotype() != null) {
                newElement.addExtension(this.context.getStereotype());
            }
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            elementInitializer.initialize((IElement)newElement);
            IBpmnDataAssociation newDataAssociation = (IBpmnDataAssociation)modelFactory.createElement("BpmnDataAssociation");
            if (this.parentElement instanceof IBpmnActivity) {
                owner = (IBpmnActivity)this.parentElement;
                if (newElement instanceof IBpmnDataOutput) {
                    owner.addDataOutputAssociation(newDataAssociation);
                    newDataAssociation.setTargetRef(newElement);
                } else {
                    owner.addDataInputAssociation(newDataAssociation);
                    newDataAssociation.addSourceRef(newElement);
                }
            } else if (this.parentElement instanceof IBpmnThrowEvent) {
                owner = (IBpmnThrowEvent)this.parentElement;
                newDataAssociation.setStartingEvent((IBpmnThrowEvent)owner);
                newDataAssociation.addSourceRef(newElement);
                newDataAssociation.addSourceRef(newElement);
            } else if (this.parentElement instanceof IBpmnCatchEvent) {
                owner = (IBpmnCatchEvent)this.parentElement;
                newDataAssociation.setEndingEvent((IBpmnCatchEvent)owner);
                newDataAssociation.setTargetRef(newElement);
            }
            dataAssociation.add(newDataAssociation);
        } else {
            dataAssociation.addAll((Collection<IBpmnDataAssociation>)newElement.getTargetOfDataAssociation());
            dataAssociation.addAll((Collection<IBpmnDataAssociation>)newElement.getSourceOfDataAssociation());
        }
        Rectangle rect = this.size != null ? new Rectangle(this.location, this.size) : new Rectangle(this.location, new Dimension(-1, -1));
        GmNodeModel createdNode = diagram.unmask(this.destNode, (IElement)newElement, (Object)rect);
        if (this.sourceNode != this.destNode) {
            for (IBpmnDataAssociation link : dataAssociation) {
                GmLink gmlink;
                if (newElement instanceof IBpmnDataOutput) {
                    gmlink = diagram.unmaskLink((IElement)link, (IGmLinkable)this.sourceNode, (IGmLinkable)createdNode, (Object)new GmPath());
                    gmlink.setSourceAnchor((GmAbstractLinkAnchor)new GmLinkAnchor(this.sourceAnchorLocation));
                    gmlink.setTargetAnchor((GmAbstractLinkAnchor)new GmLinkAnchor(new Dimension(0, 10)));
                    continue;
                }
                gmlink = diagram.unmaskLink((IElement)link, (IGmLinkable)createdNode, (IGmLinkable)this.sourceNode, (Object)new GmPath());
                gmlink.setSourceAnchor((GmAbstractLinkAnchor)new GmLinkAnchor(this.sourceAnchorLocation));
                gmlink.setTargetAnchor((GmAbstractLinkAnchor)new GmLinkAnchor(new Dimension(0, 10)));
            }
        }
    }

    public void setDestinationNode(GmCompositeNode destNode) {
        this.destNode = destNode;
    }

    public void setNodeLocation(Point location) {
        this.location = location;
    }

    public void setNodeSize(Dimension size) {
        this.size = size;
    }

    public void setParentElement(IElement parentElement) {
        this.parentElement = parentElement;
    }

    public void setSourceAnchorLocation(Dimension location) {
        this.sourceAnchorLocation = location;
    }

    public void setSourceNode(GmNodeModel sourceNode) {
        this.sourceNode = sourceNode;
        this.parentElement = sourceNode.getRelatedIElement();
    }
}

