/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnmessage;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessageFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmndataobject.BpmnDataFigure;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnmessage.GmBpmnMessageLink;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnmessage.GmBpmnMessagePrimaryNode;
import com.modeliosoft.modelio.diagram.editor.bpmn.plugin.DiagramEditorBPMN;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeEndReconnectEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.figures.ColorizableImageFigure;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class BpmnMessageEditPart
extends GmNodeEditPart {
    public boolean isSelectable() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue;
        if (evt.getPropertyName().equals("Name")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
        if (evt.getPropertyName().equals("Link source") && (newValue = evt.getNewValue()) != null && newValue instanceof IBpmnMessageFlow) {
            this.createMissingLinkForElement((IBpmnMessageFlow)newValue);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"NodeEditPolicy", (EditPolicy)new DefaultCreateLinkEditPolicy());
        this.installEditPolicy((Object)"linkedNode", (EditPolicy)new LinkedNodeEndReconnectEditPolicy());
    }

    protected IFigure createFigure() {
        BpmnDataFigure figure1 = new BpmnDataFigure();
        figure1.setPreferredSize(40, 55);
        figure1.setOpaque(true);
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(DiagramEditorBPMN.getInstance().getImageRegistry().getImage("Static_Message"));
        figure1.setCenterIcone(images);
        this.refreshFromStyle((IFigure)figure1, this.getModelStyle());
        return figure1;
    }

    protected void refreshVisuals() {
        BpmnDataFigure noteFigure = (BpmnDataFigure)this.getFigure();
        GmBpmnMessagePrimaryNode noteModel = (GmBpmnMessagePrimaryNode)this.getModel();
        noteFigure.getParent().setConstraint((IFigure)noteFigure, noteModel.getLayoutData());
        noteFigure.setTopIcone(noteModel.getReferenceIcone());
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        if (aFigure instanceof ColorizableImageFigure) {
            ColorizableImageFigure cFigure = (ColorizableImageFigure)aFigure;
            GmModel gmModel = (GmModel)this.getModel();
            Color color = style.getColor(gmModel.getStyleKey(MetaKey.FILLCOLOR));
            cFigure.setColor(color);
        }
        super.refreshFromStyle(aFigure, style);
    }

    public SelectionEditPolicy getPreferredDragRolePolicy(String requestType) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createMissingLinkForElement(IBpmnMessageFlow constrainedElement) {
        IGmLinkable sourceModel = (IGmLinkable)this.getModel();
        GmBpmnMessageLink link = new GmBpmnMessageLink(sourceModel.getDiagram(), new ObRef(sourceModel.getRelatedIElement()));
        sourceModel.addStartingLink((IGmLink)link);
        CreateConnectionRequest request = new CreateConnectionRequest();
        request.setType((Object)"connection end");
        request.setSourceEditPart((EditPart)this);
        request.setLocation(new Point(0, 0));
        ModelioLinkCreationContext context = new ModelioLinkCreationContext(sourceModel.getRelatedIElement());
        request.setFactory((CreationFactory)context);
        DefaultCreateLinkCommand startCommand = new DefaultCreateLinkCommand(context);
        startCommand.setSource(sourceModel);
        request.setStartCommand((Command)startCommand);
        List constrainedElementModels = sourceModel.getDiagram().getAllGMRelatedTo(new ObRef((IElement)constrainedElement));
        for (GmModel constrainedElementModel : constrainedElementModels) {
            EditPart targetEditPart;
            EditPart editPart = (EditPart)this.getViewer().getEditPartRegistry().get(constrainedElementModel);
            if (editPart == null || (targetEditPart = editPart.getTargetEditPart((Request)request)) == null) continue;
            IGmLinkable targetModel = (IGmLinkable)targetEditPart.getModel();
            targetModel.addEndingLink((IGmLink)link);
            break;
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (index == 0) {
            this.getFigure().add(child, (Object)BorderLayout.CENTER, index);
        }
    }
}

