/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnmessage;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessage;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessageFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;

public class UnmaskBpmnMessageCommand
extends Command {
    private final IBpmnMessage theBpmnMessage;
    private final Object constraint;
    private final GmAbstractDiagram diagram;
    private final AbstractDiagramEditPart host;
    private final Point dropLocation;

    public UnmaskBpmnMessageCommand(IBpmnMessage theBpmnMessage, AbstractDiagramEditPart host, Object initialLayoutData, Point dropLocation) {
        this.theBpmnMessage = theBpmnMessage;
        this.host = host;
        this.diagram = (GmAbstractDiagram)host.getModel();
        this.constraint = initialLayoutData;
        this.dropLocation = dropLocation;
    }

    public void execute() {
        GmNodeModel targetModel = this.diagram.unmask((GmCompositeNode)this.diagram, (IElement)this.theBpmnMessage, this.constraint);
        CreateConnectionRequest req = new CreateConnectionRequest();
        req.setLocation(this.dropLocation);
        req.setSize(new Dimension(-1, -1));
        req.setFactory((CreationFactory)new ModelioLinkCreationContext((IElement)this.theBpmnMessage));
        req.setType((Object)"connection start");
        ObList subjects = this.theBpmnMessage.getMessageFlow();
        for (IBpmnMessageFlow subject : subjects) {
            EditPart sourceEditPart = this.getEditPartFor((IElement)subject, req);
            if (sourceEditPart == null) {
                this.unmaskElement((IElement)subject, this.dropLocation.getTranslated(-50, 0));
                sourceEditPart = this.getEditPartFor((IElement)subject, req);
                if (sourceEditPart == null) {
                    targetModel.delete();
                    return;
                }
            }
            IGmLinkable sourceModel = (IGmLinkable)sourceEditPart.getModel();
            GmLink link = this.diagram.unmaskLink((IElement)this.theBpmnMessage);
            targetModel.addEndingLink((IGmLink)link);
            sourceModel.addStartingLink((IGmLink)link);
        }
    }

    private EditPart getEditPartFor(IElement element, CreateConnectionRequest req) {
        List models = this.diagram.getAllGMRelatedTo(new ObRef(element));
        for (GmModel model : models) {
            EditPart targetEditPart;
            EditPart editPart = (EditPart)this.host.getViewer().getEditPartRegistry().get(model);
            if (editPart == null || (targetEditPart = editPart.getTargetEditPart((Request)req)) == null) continue;
            return targetEditPart;
        }
        return null;
    }

    private void unmaskElement(IElement element, Point location) {
        ModelElementDropRequest dropRequest = new ModelElementDropRequest();
        dropRequest.setDroppedElements(new IElement[]{element});
        dropRequest.setLocation(location);
        EditPart targetEditPart = this.host.getTargetEditPart((Request)dropRequest);
        Command command = targetEditPart.getCommand((Request)dropRequest);
        if (command != null && command.canExecute()) {
            command.execute();
        }
    }
}

