/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnnodefooter;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.Collections;
import java.util.List;

public class GmBpmnNodeFooter
extends GmCompositeNode {
    private final int minorVersion = 0;
    private Boolean isEmptySubProcess;
    private Boolean isLoop;
    private Boolean isParallel;
    private Boolean isSequential;
    private Boolean isAdHoc;
    private Boolean isCompensation;
    private Boolean isNonEmptySubProcess;
    private static final int MAJOR_VERSION = 0;

    public GmBpmnNodeFooter(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.isEmptySubProcess = false;
        this.isNonEmptySubProcess = false;
        this.isLoop = false;
        this.isParallel = false;
        this.isSequential = false;
        this.isAdHoc = false;
        this.isCompensation = false;
    }

    protected void setParent(GmCompositeNode parent) {
        if (parent != null && this.getParent() != parent) {
            this.getStyle().setCascadedStyle(parent.getStyle());
        }
        super.setParent(parent);
    }

    public boolean canUnmask(IElement el) {
        return false;
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return false;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return Collections.emptyList();
    }

    public StyleKey.RepresentationMode getRepresentationMode() {
        if (this.getParent() == null) {
            return StyleKey.RepresentationMode.STRUCTURED;
        }
        return this.getParent().getRepresentationMode();
    }

    public GmBpmnNodeFooter() {
    }

    public GmCompositeNode getCompositeFor(Class<? extends IElement> metaclass) {
        return null;
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmBpmnNodeFooter.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("EmptySubProcess", this.isEmptySubProcess());
        out.writeProperty("NonEmptySubProcess", this.isNonEmptySubProcess());
        out.writeProperty("Loop", this.isLoop());
        out.writeProperty("Parallel", this.isParallel());
        out.writeProperty("Sequential", this.isSequential());
        out.writeProperty("AdHoc", this.isAdHoc());
        out.writeProperty("Compensation", this.isCompensation());
        if (false) {
            out.writeProperty("GmBpmnNodeFooter.version", (Object)0);
        }
    }

    public Boolean isEmptySubProcess() {
        return this.isEmptySubProcess;
    }

    public void setEmptySubProcess(Boolean isSubProcess) {
        this.isEmptySubProcess = isSubProcess;
        this.firePropertyChange("LayoutData", null, (Object)isSubProcess);
    }

    public Boolean isLoop() {
        return this.isLoop;
    }

    public void setLoop(Boolean isLoop) {
        this.isLoop = isLoop;
        this.firePropertyChange("LayoutData", null, (Object)isLoop);
    }

    public Boolean isParallel() {
        return this.isParallel;
    }

    public void setParallel(Boolean isParallel) {
        this.isParallel = isParallel;
        this.firePropertyChange("LayoutData", null, (Object)isParallel);
    }

    public Boolean isSequential() {
        return this.isSequential;
    }

    public void setSequential(Boolean isSequential) {
        this.isSequential = isSequential;
        this.firePropertyChange("LayoutData", null, (Object)isSequential);
    }

    public Boolean isAdHoc() {
        return this.isAdHoc;
    }

    public void setAdHoc(Boolean isAdHoc) {
        this.isAdHoc = isAdHoc;
        this.firePropertyChange("LayoutData", null, (Object)isAdHoc);
    }

    public Boolean isCompensation() {
        return this.isCompensation;
    }

    public void setCompensation(Boolean isCompensation) {
        this.isCompensation = isCompensation;
        this.firePropertyChange("LayoutData", null, (Object)isCompensation);
    }

    public Boolean isNonEmptySubProcess() {
        return this.isNonEmptySubProcess;
    }

    public void setNonEmptySubProcess(Boolean isSubProcess) {
        this.isNonEmptySubProcess = isSubProcess;
        this.firePropertyChange("LayoutData", null, (Object)isSubProcess);
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.setEmptySubProcess((Boolean)in.readProperty("EmptySubProcess"));
        this.setNonEmptySubProcess((Boolean)in.readProperty("NonEmptySubProcess"));
        this.setLoop((Boolean)in.readProperty("Loop"));
        this.setParallel((Boolean)in.readProperty("Parallel"));
        this.setSequential((Boolean)in.readProperty("Sequential"));
        this.setAdHoc((Boolean)in.readProperty("AdHoc"));
        this.setCompensation((Boolean)in.readProperty("Compensation"));
    }

    public int getMajorVersion() {
        return 0;
    }
}

