/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnsequenceflow;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnBoundaryEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnGateway;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnsequenceflow.GmBpmnSequenceFlow;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnsequenceflow.SequenceFlowEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeStartCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.figures.decorations.DefaultPolygonDecoration;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkEditPart;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkLayoutEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultDeleteLinkEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.policies.DelegatingDirectEditionEditPolicy;
import com.modeliosoft.modelio.diagram.elements.umlcommon.constraint.ConstraintLinkEditPolicy;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;

public class BpmnSequenceFlowEditPart
extends GmLinkEditPart {
    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        connection.setTargetDecoration((RotatableDecoration)this.getArrowDecoration());
        return connection;
    }

    private DefaultPolygonDecoration getArrowDecoration() {
        DefaultPolygonDecoration decoration = new DefaultPolygonDecoration();
        decoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        decoration.setScale(8.0, 5.0);
        decoration.setOpaque(true);
        decoration.setFill(true);
        return decoration;
    }

    private DefaultPolygonDecoration getDiamondDecoration() {
        DefaultPolygonDecoration decoration = new DefaultPolygonDecoration();
        int[] nArray = new int[10];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -2;
        nArray[8] = -1;
        nArray[9] = 1;
        PointList points = new PointList(nArray);
        decoration.setTemplate(points);
        decoration.setScale(8.0, 5.0);
        decoration.setOpaque(true);
        decoration.setFill(true);
        decoration.setBackgroundColor(ColorConstants.white);
        return decoration;
    }

    private DefaultPolygonDecoration getCrossDecoration() {
        DefaultPolygonDecoration decoration = new DefaultPolygonDecoration();
        PointList points = new PointList(new int[]{-5, -5, -20, 5});
        decoration.setTemplate(points);
        decoration.setScale(1.0, 1.0);
        decoration.setOpaque(true);
        return decoration;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GmBpmnSequenceFlow gmmodel = (GmBpmnSequenceFlow)this.getModel();
        IBpmnSequenceFlow flow = gmmodel.getRepresentedIElement();
        PolylineConnection pfigure = (PolylineConnection)this.getFigure();
        if (flow.getDefaultFrom() != null || flow.getDefaultOfExclusive() != null || flow.getDefaultOfInclusive() != null || flow.getDefaultOfComplex() != null) {
            pfigure.setSourceDecoration((RotatableDecoration)this.getCrossDecoration());
        } else if (!flow.getConditionExpression().equals("")) {
            if (!(flow.getSourceRef() instanceof IBpmnGateway) && !(flow.getSourceRef() instanceof IBpmnBoundaryEvent)) {
                pfigure.setSourceDecoration((RotatableDecoration)this.getDiamondDecoration());
            } else {
                pfigure.setSourceDecoration(null);
            }
        } else {
            pfigure.setSourceDecoration(null);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new SequenceFlowEditPolicy());
        this.installEditPolicy((Object)"Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy((Object)"NodeEditPolicy", (EditPolicy)new DefaultCreateLinkEditPolicy(true));
        this.installEditPolicy((Object)"ConnectionEditPolicy", (EditPolicy)new DefaultDeleteLinkEditPolicy());
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new GmLinkLayoutEditPolicy());
        this.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new DelegatingDirectEditionEditPolicy());
        this.installEditPolicy((Object)"Linked node start", (EditPolicy)new LinkedNodeStartCreationEditPolicy());
        this.installEditPolicy((Object)"Multipoint First", (EditPolicy)new ConstraintLinkEditPolicy(false));
    }
}

