/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnBoundaryEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataAssociation;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnGroup;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLaneSet;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessage;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessageFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnParticipant;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.usecase.IActor;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.bpmnmessage.UnmaskBpmnMessageCommand;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.SmartCallActivityCommand;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.SmartDataObjectCommand;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.SmartPoolCommand;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class BpmnDiagramElementDropEditPolicy
extends DiagramElementDropEditPolicy {
    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            if (toUnmask instanceof IBpmnParticipant || toUnmask instanceof IBpmnGroup) {
                return null;
            }
            if (toUnmask instanceof IBpmnFlowElement || toUnmask instanceof IBpmnLane || toUnmask instanceof IBpmnProcess || toUnmask instanceof IBehavior || toUnmask instanceof IOperation || toUnmask instanceof IBpmnDataAssociation || toUnmask instanceof IBpmnMessageFlow || toUnmask instanceof IBpmnMessage || toUnmask instanceof INote || toUnmask instanceof IExternDocument || toUnmask instanceof IState || toUnmask instanceof IGeneralClass || toUnmask instanceof IConstraint || toUnmask instanceof IDependency || toUnmask instanceof IAbstractDiagram) {
                return this.getHost();
            }
            ++n2;
        }
        return null;
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IAbstractDiagram diag = (IAbstractDiagram)gmDiagram.getRelatedIElement();
        IModelElement owner = diag.getOrigin();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            if (toUnmask instanceof IBpmnProcess || toUnmask instanceof IBehavior || toUnmask instanceof IOperation && request.isSmart()) {
                command.add(this.getProcessDropCommand(dropLocation, toUnmask));
            } else if (toUnmask instanceof IActor && owner instanceof IBpmnProcess && request.isSmart()) {
                command.add(this.getPoolDropCommand(dropLocation, (IActor)toUnmask));
            } else if (toUnmask instanceof IGeneralClass || toUnmask instanceof IState && request.isSmart()) {
                command.add(this.getDataObjectDropCommand(dropLocation, toUnmask));
            } else if (toUnmask instanceof IBpmnMessage && request.isSmart()) {
                command.add(this.getMessageDropCommand(dropLocation, toUnmask));
            } else if (toUnmask != null) {
                this.createSubRequest(request, command, dropLocation, toUnmask);
            }
            dropLocation = dropLocation.getTranslated(20, 20);
            ++n2;
        }
        return command;
    }

    private Command getProcessDropCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IAbstractDiagram diag = (IAbstractDiagram)gmDiagram.getRelatedIElement();
        IModelElement owner = diag.getOrigin();
        return new SmartCallActivityCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private Command getMessageDropCommand(Point dropLocation, IElement toUnmask) {
        return new UnmaskBpmnMessageCommand((IBpmnMessage)toUnmask, (AbstractDiagramEditPart)this.getHost(), (Object)new Rectangle(dropLocation, new Dimension(-1, -1)), dropLocation);
    }

    private Command getDataObjectDropCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IAbstractDiagram diag = (IAbstractDiagram)gmDiagram.getRelatedIElement();
        IModelElement owner = diag.getOrigin();
        return new SmartDataObjectCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private Command getPoolDropCommand(Point dropLocation, IActor toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IAbstractDiagram diag = (IAbstractDiagram)gmDiagram.getRelatedIElement();
        IBpmnProcess owner = (IBpmnProcess)diag.getOrigin();
        return new SmartPoolCommand(dropLocation, toUnmask, this.getHost(), owner);
    }

    protected IElement getComposition(IElement element) {
        IBpmnFlowElement flowelement;
        if (element instanceof IBpmnBoundaryEvent) {
            IBpmnBoundaryEvent event = (IBpmnBoundaryEvent)element;
            return event.getAttachedToRef();
        }
        if (element instanceof IBpmnFlowElement && (flowelement = (IBpmnFlowElement)element).getLane().size() > 0) {
            return (IElement)flowelement.getLane().get(0);
        }
        if (element instanceof IBpmnLane) {
            IBpmnLane lane = (IBpmnLane)element;
            IBpmnLaneSet laneset = lane.getLaneSet();
            return laneset.getCompositionOwner();
        }
        return element.getCompositionOwner();
    }

    private void createSubRequest(ModelElementDropRequest request, CompoundCommand command, Point dropLocation, IElement toUnmask) {
        ModelElementDropRequest subReq = new ModelElementDropRequest();
        subReq.setDroppedElements(new IElement[]{toUnmask});
        subReq.setExtendedData(request.getExtendedData());
        subReq.setLocation(dropLocation);
        subReq.isSmart(request.isSmart());
        command.add(super.getDropCommand(subReq));
    }
}

