/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnCallActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class SmartCallActivityCommand
extends Command {
    private EditPart editPart;
    private IElement element;
    private Point dropLocation;
    private IElement parentElement;

    public SmartCallActivityCommand(Point dropLocation, IElement toUnmask, EditPart editPart, IElement parentElement) {
        this.element = toUnmask;
        this.dropLocation = dropLocation;
        this.editPart = editPart;
        this.parentElement = parentElement;
    }

    public void execute() {
        GmModel gmModel = (GmModel)this.editPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IBpmnCallActivity el = (IBpmnCallActivity)factory.createElement("BpmnCallActivity");
        DefaultNameFactory.setDefaultName((IModelElement)el);
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)el);
        if (effectiveDependency == null || effectiveDependency.isEmpty()) {
            throw new IllegalStateException("Cannot find a composition dependency to attach " + el.toString() + " to " + this.parentElement.toString());
        }
        Meta meta = new Meta(this.parentElement);
        meta.appendToDependency(effectiveDependency, (IElement)el);
        if (this.parentElement instanceof IBpmnLane) {
            IBpmnLane lane = (IBpmnLane)this.parentElement;
            el.addLane((IBpmnLane)this.parentElement);
            this.parentElement = lane.getLaneSet().getProcess() != null ? lane.getLaneSet().getProcess() : lane.getLaneSet().getSubProcess();
        }
        if (this.parentElement instanceof IBpmnProcess) {
            el.setContainer((IBpmnProcess)this.parentElement);
        } else if (this.parentElement instanceof IBpmnSubProcess) {
            el.setSubProcess((IBpmnSubProcess)this.parentElement);
        }
        if (this.element instanceof IBpmnProcess) {
            el.setCalledProcess((IBpmnProcess)this.element);
        } else if (this.element instanceof IOperation) {
            el.setCalledOperation((IOperation)this.element);
        } else if (this.element instanceof IBehavior) {
            el.setCalledBehavior((IBehavior)this.element);
        }
        this.unmaskElement((IElement)el);
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.dropLocation);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.editPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }

    public boolean canExecute() {
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }
}

