/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.processcollaboration;

import com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.BpmnDiagramElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.GmBpmnDiagramStyleKeys;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.diagrams.processcollaboration.BpmnProcessCollaborationDiagramFigure;
import com.modeliosoft.modelio.diagram.editor.bpmn.elements.policies.BpmnDiagramLayoutEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramFigure;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeFinishCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.model.GmAbstractObject;
import com.modeliosoft.modelio.diagram.elements.core.policies.CreateLinkIntermediateEditPolicy;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class BpmnProcessCollaborationDiagramEditPart
extends AbstractDiagramEditPart {
    protected IFigure createFigure() {
        BpmnProcessCollaborationDiagramFigure diagramFigure = new BpmnProcessCollaborationDiagramFigure();
        IStyle style = ((GmAbstractObject)this.getModel()).getStyle();
        this.refreshFromStyle((IFigure)diagramFigure, style);
        return diagramFigure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new BpmnDiagramLayoutEditPolicy());
        this.installEditPolicy((Object)"Linked node end", (EditPolicy)new LinkedNodeFinishCreationEditPolicy());
        this.installEditPolicy((Object)"add bendpoint to future connection", (EditPolicy)new CreateLinkIntermediateEditPolicy());
        this.installEditPolicy((Object)"DROPELEMENT", (EditPolicy)new BpmnDiagramElementDropEditPolicy());
        this.installEditPolicy((Object)"DirectEditPolicy", null);
    }

    public EditPart getTargetEditPart(Request request) {
        return super.getTargetEditPart(request);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        PrecisionDimension inchPageSize;
        AbstractDiagramFigure diagramFigure = (AbstractDiagramFigure)aFigure;
        boolean viewGrid = style.getBoolean(GmBpmnDiagramStyleKeys.VIEWGRID);
        boolean snapToGrid = style.getBoolean(GmBpmnDiagramStyleKeys.SNAPTOGRID);
        Color gridColor = style.getColor(GmBpmnDiagramStyleKeys.GRIDCOLOR);
        int gridAlpha = style.getInteger(GmBpmnDiagramStyleKeys.GRIDALPHA);
        int gridSpacing = style.getInteger(GmBpmnDiagramStyleKeys.GRIDSPACING);
        Color fillColor = style.getColor(GmBpmnDiagramStyleKeys.FILLCOLOR);
        String fillImage = (String)style.getProperty(GmBpmnDiagramStyleKeys.FILLIMAGE);
        int fillAlpha = style.getInteger(GmBpmnDiagramStyleKeys.FILLALPHA);
        String pageSize = (String)style.getProperty(GmBpmnDiagramStyleKeys.PAGE_SIZE);
        PrecisionDimension pixelPageSize = null;
        if (pageSize != null && !pageSize.isEmpty() && (inchPageSize = this.parsePageSize(pageSize)) != null) {
            pixelPageSize = this.convertToPixel(inchPageSize);
        }
        EditPartViewer v = this.getRoot().getViewer();
        v.setProperty("SnapToGrid.isVisible", (Object)new Boolean(viewGrid));
        v.setProperty("SnapToGrid.isEnabled", (Object)new Boolean(snapToGrid));
        v.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridSpacing, gridSpacing));
        v.setProperty("AbstractDiagramEditPart.GridColor", (Object)gridColor);
        v.setProperty("AbstractDiagramEditPart.GridAlpha", (Object)new Integer(gridAlpha));
        v.setProperty("AbstractDiagramEditPart.FillColor", (Object)fillColor);
        v.setProperty("AbstractDiagramEditPart.FillImage", (Object)fillImage);
        v.setProperty("AbstractDiagramEditPart.FillAlpha", (Object)new Integer(fillAlpha));
        diagramFigure.showPageBoundaries(style.getBoolean(GmBpmnDiagramStyleKeys.SHOW_PAGES));
        v.setProperty("AbstractDiagramEditPart.FillTileSize", (Object)pixelPageSize);
        diagramFigure.setPageBoundaries((Dimension)pixelPageSize);
    }

    private PrecisionDimension convertToPixel(PrecisionDimension d) {
        Point dpi = Display.getCurrent().getDPI();
        return new PrecisionDimension(d.preciseWidth * (double)dpi.x, d.preciseHeight * (double)dpi.y);
    }

    private PrecisionDimension parsePageSize(String value) {
        float oneInch = 25.4f;
        String s = value.replaceAll(" ", "");
        if ("A0H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(1189.0, 841.0));
        }
        if ("A0V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(841.0, 1189.0));
        }
        if ("A1H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(841.0, 594.0));
        }
        if ("A1V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(594.0, 841.0));
        }
        if ("A2H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(594.0, 420.0));
        }
        if ("A2V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(420.0, 594.0));
        }
        if ("A3H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(420.0, 297.0));
        }
        if ("A3V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(297.0, 420.0));
        }
        if ("A4H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(297.0, 210.0));
        }
        if ("A4V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(210.0, 297.0));
        }
        if ("A5H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(210.0, 148.0));
        }
        if ("A5V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(148.0, 210.0));
        }
        Pattern whR = Pattern.compile("(\\d+\\.?\\d*.*)(x|X)(\\d+\\.?\\d*.*)", 2);
        System.out.println(whR.toString());
        Matcher whM = whR.matcher(s);
        if (whM.matches()) {
            String widthString = whM.group(1);
            String heightString = whM.group(3);
            float width = widthString.endsWith("\"") ? Float.parseFloat(widthString.replaceAll("[^0-9\\.]", "")) : Float.parseFloat(widthString.replaceAll("[^0-9\\.]", "")) / 25.4f;
            float height = heightString.endsWith("\"") ? Float.parseFloat(heightString.replaceAll("[^0-9\\.]", "")) : Float.parseFloat(heightString.replaceAll("[^0-9\\.]", "")) / 25.4f;
            return new PrecisionDimension((double)width, (double)height);
        }
        return null;
    }

    private PrecisionDimension convertMmToInch(PrecisionDimension d) {
        if (d == null) {
            return null;
        }
        float factor = 25.4f;
        return new PrecisionDimension(d.preciseWidth / (double)25.4f, d.preciseHeight / (double)25.4f);
    }
}

