/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.policies;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnBoundaryEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class BpmnBoundaryEventReparentElementCommand
extends Command {
    private Object newLayoutData;
    private GmCompositeNode newParent;
    private GmNodeModel reparentedChild;
    private IElement newParentElement;

    public BpmnBoundaryEventReparentElementCommand(IElement newParentElement, GmCompositeNode newParent, GmNodeModel reparentedChild, Object newLayoutData) {
        this.newParentElement = newParentElement;
        this.newParent = newParent;
        this.reparentedChild = reparentedChild;
        this.newLayoutData = newLayoutData;
    }

    public boolean canExecute() {
        IElement childElement = this.reparentedChild.getRelatedIElement();
        if (this.newParentElement == null || childElement == null) {
            return false;
        }
        return this.newParentElement.getElementStatus().isModifiable() && childElement.getElementStatus().isModifiable();
    }

    public void execute() {
        IBpmnProcess process;
        IBpmnSubProcess subprocess;
        IBpmnBoundaryEvent childElement = (IBpmnBoundaryEvent)this.reparentedChild.getRelatedIElement();
        IElement newParentElem = this.newParentElement;
        assert (childElement != null) : "cannot reparent: child element is null";
        IBpmnActivity activity = childElement.getAttachedToRef();
        if (activity != null) {
            activity.removeBoundaryEventRef(childElement);
        }
        if ((subprocess = childElement.getSubProcess()) != null) {
            subprocess.removeFlowElement((IBpmnFlowElement)childElement);
        }
        if ((process = childElement.getContainer()) != null) {
            process.removeFlowElement((IBpmnFlowElement)childElement);
        }
        GmModel oldParentModel = this.reparentedChild.getParent();
        assert (oldParentModel instanceof GmCompositeNode) : "This command should only be used if both old parent and new parent are instances of GmCompositeNode!";
        GmCompositeNode oldParent = (GmCompositeNode)oldParentModel;
        oldParent.removeChild(this.reparentedChild);
        childElement.setAttachedToRef((IBpmnActivity)newParentElem);
        newParentElem = this.getOwnerProcess(newParentElem);
        if (newParentElem instanceof IBpmnProcess) {
            childElement.setContainer((IBpmnProcess)newParentElem);
        }
        if (newParentElem instanceof IBpmnSubProcess) {
            childElement.setSubProcess((IBpmnSubProcess)newParentElem);
        }
        this.reparentedChild.setLayoutData(this.newLayoutData);
        if (this.newParent.canContain(this.reparentedChild.getClass())) {
            this.newParent.addChild(this.reparentedChild);
        } else {
            if (this.newLayoutData instanceof Rectangle) {
                Rectangle r = (Rectangle)this.newLayoutData;
                this.newLayoutData = new Rectangle(r.x, r.y, -1, -1);
            }
            this.newParent.getDiagram().unmask(this.newParent, this.reparentedChild.getRelatedIElement(), this.newLayoutData);
            this.reparentedChild.delete();
        }
        super.execute();
    }

    private IElement getOwnerProcess(IElement childElement) {
        if (childElement instanceof IBpmnProcess || childElement instanceof IBpmnSubProcess) {
            return childElement;
        }
        return this.getOwnerProcess(childElement.getCompositionOwner());
    }
}

