/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.policies;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class BpmnFlowElementReparentElementCommand
extends Command {
    private Object newLayoutData;
    private GmCompositeNode newParent;
    private GmNodeModel reparentedChild;
    private IElement newParentElement;

    public BpmnFlowElementReparentElementCommand(IElement newParentElement, GmCompositeNode newParent, GmNodeModel reparentedChild, Object newLayoutData) {
        this.newParentElement = newParentElement;
        this.newParent = newParent;
        this.reparentedChild = reparentedChild;
        this.newLayoutData = newLayoutData;
    }

    public boolean canExecute() {
        IElement childElement = this.reparentedChild.getRelatedIElement();
        if (this.newParentElement == null || childElement == null) {
            return false;
        }
        return this.newParentElement.getElementStatus().isModifiable() && childElement.getElementStatus().isModifiable();
    }

    public void execute() {
        IBpmnSubProcess ownersubprocess;
        IBpmnProcess ownerprocess;
        IBpmnFlowElement childElement = (IBpmnFlowElement)this.reparentedChild.getRelatedIElement();
        IElement parent = this.reparentedChild.getParent().getRelatedIElement();
        IElement newParentElem = this.newParentElement;
        assert (childElement != null) : "cannot reparent: child element is null";
        if (parent instanceof IBpmnLane) {
            childElement.removeLane((IBpmnLane)parent);
        }
        if ((ownerprocess = childElement.getContainer()) != null) {
            ownerprocess.removeFlowElement(childElement);
        }
        if ((ownersubprocess = childElement.getSubProcess()) != null) {
            ownersubprocess.removeFlowElement(childElement);
        }
        GmModel oldParentModel = this.reparentedChild.getParent();
        assert (oldParentModel instanceof GmCompositeNode) : "This command should only be used if both old parent and new parent are instances of GmCompositeNode!";
        GmCompositeNode oldParent = (GmCompositeNode)oldParentModel;
        oldParent.removeChild(this.reparentedChild);
        if (newParentElem instanceof IBpmnLane) {
            childElement.addLane((IBpmnLane)newParentElem);
            newParentElem = this.getOwnerProcess(newParentElem);
        }
        if (newParentElem instanceof IBpmnProcess) {
            childElement.setContainer((IBpmnProcess)newParentElem);
        }
        if (newParentElem instanceof IBpmnSubProcess) {
            childElement.setSubProcess((IBpmnSubProcess)newParentElem);
        }
        this.reparentedChild.setLayoutData(this.newLayoutData);
        if (this.newParent.canContain(this.reparentedChild.getClass())) {
            this.newParent.addChild(this.reparentedChild);
        } else {
            if (this.newLayoutData instanceof Rectangle) {
                Rectangle r = (Rectangle)this.newLayoutData;
                this.newLayoutData = new Rectangle(r.x, r.y, -1, -1);
            }
            this.newParent.getDiagram().unmask(this.newParent, this.reparentedChild.getRelatedIElement(), this.newLayoutData);
            this.reparentedChild.delete();
        }
        super.execute();
    }

    private IElement getOwnerProcess(IElement childElement) {
        if (childElement instanceof IBpmnProcess || childElement instanceof IBpmnSubProcess) {
            return childElement;
        }
        return this.getOwnerProcess(childElement.getCompositionOwner());
    }
}

