/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.policies;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLaneSet;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class BpmnLaneReparentElementCommand
extends Command {
    private Object newLayoutData;
    private GmCompositeNode newParent;
    private GmNodeModel reparentedChild;
    private IElement newParentElement;

    public BpmnLaneReparentElementCommand(IElement newParentElement, GmCompositeNode newParent, GmNodeModel reparentedChild, Object newLayoutData) {
        this.newParentElement = newParentElement;
        this.newParent = newParent;
        this.reparentedChild = reparentedChild;
        this.newLayoutData = newLayoutData;
    }

    public boolean canExecute() {
        IElement childElement = this.reparentedChild.getRelatedIElement();
        if (this.newParentElement == null || childElement == null) {
            return false;
        }
        if (!this.newParentElement.getElementStatus().isModifiable() || !childElement.getElementStatus().isModifiable()) {
            return false;
        }
        return !(this.newParentElement instanceof IBpmnLaneSet) || !(this.newParentElement.getCompositionOwner() instanceof IBpmnProcess);
    }

    public void execute() {
        IBpmnLane childElement = (IBpmnLane)this.reparentedChild.getRelatedIElement();
        IElement newParentElem = this.newParentElement;
        assert (childElement != null) : "cannot reparent: child element is null";
        if (newParentElem.equals((Object)childElement.getLaneSet().getCompositionOwner())) {
            return;
        }
        IBpmnLaneSet laneset = childElement.getLaneSet();
        if (laneset != null) {
            laneset.removeLane(childElement);
            if (laneset.getLane().size() == 0) {
                laneset.delete();
            }
        }
        GmModel oldParentModel = this.reparentedChild.getParent();
        assert (oldParentModel instanceof GmCompositeNode) : "This command should only be used if both old parent and new parent are instances of GmCompositeNode!";
        GmCompositeNode oldParent = (GmCompositeNode)oldParentModel;
        oldParent.removeChild(this.reparentedChild);
        if (newParentElem instanceof IBpmnLane) {
            IBpmnLane parentLane = (IBpmnLane)newParentElem;
            if (parentLane.getChildLaneSet() != null) {
                newParentElem = parentLane.getChildLaneSet();
            } else {
                GmAbstractDiagram diagram = this.newParent.getDiagram();
                IModelFactory modelFactory = diagram.getModelFactory();
                IBpmnLaneSet newElement = (IBpmnLaneSet)modelFactory.createElement("BpmnLaneSet");
                parentLane.setChildLaneSet(newElement);
                IElementInitializer elementInitializer = diagram.getElementInitializer();
                elementInitializer.initialize((IElement)newElement);
                this.newParent = (GmCompositeNode)diagram.unmask(this.newParent, (IElement)newElement, this.newLayoutData);
                newParentElem = newElement;
            }
        } else if (newParentElem instanceof IBpmnProcess) {
            IBpmnProcess process = (IBpmnProcess)newParentElem;
            GmAbstractDiagram diagram = this.newParent.getDiagram();
            IModelFactory modelFactory = diagram.getModelFactory();
            IBpmnLaneSet newElement = (IBpmnLaneSet)modelFactory.createElement("BpmnLaneSet");
            process.addLaneSet(newElement);
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            elementInitializer.initialize((IElement)newElement);
            newParentElem = newElement;
        }
        if (newParentElem instanceof IBpmnLaneSet) {
            childElement.setLaneSet((IBpmnLaneSet)newParentElem);
        }
        this.reparentedChild.setLayoutData(this.newLayoutData);
        if (this.newParent.canContain(this.reparentedChild.getClass())) {
            this.newParent.addChild(this.reparentedChild);
        } else {
            if (this.newLayoutData instanceof Rectangle) {
                Rectangle r = (Rectangle)this.newLayoutData;
                this.newLayoutData = new Rectangle(r.x, r.y, -1, -1);
            }
            this.newParent.getDiagram().unmask(this.newParent, this.reparentedChild.getRelatedIElement(), this.newLayoutData);
            this.reparentedChild.delete();
        }
        super.execute();
    }
}

