/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.bpmn.elements.policies;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultCreateElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;

public class CreateBpmnFlowElementCommand
extends DefaultCreateElementCommand {
    public CreateBpmnFlowElementCommand(GmCompositeNode parentNode, ModelioCreationContext context, Object constraint) {
        super(parentNode, context, constraint);
    }

    public CreateBpmnFlowElementCommand(IElement parentNode, GmCompositeNode parentElement, ModelioCreationContext context, Object constraint) {
        super(parentNode, parentElement, context, constraint);
    }

    public void execute() {
        GmAbstractDiagram diagram = this.getParentNode().getDiagram();
        IElement newElement = this.getContext().getElementToUnmask();
        if (newElement == null) {
            IModelFactory modelFactory = diagram.getModelFactory();
            newElement = modelFactory.createElement(this.getContext().getMetaclass());
            String effectiveDependency = this.getContext().getDependency();
            if (effectiveDependency == null) {
                effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)this.getParentElement(), (IElement)newElement);
            }
            Meta meta = new Meta(this.getParentElement());
            try {
                meta.appendToDependency(effectiveDependency, newElement);
            }
            catch (InvalidModelManipulationException e) {
                String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.getParentElement(), (IElement)newElement);
                if (compositionDep != null && !compositionDep.equals("")) {
                    meta.appendToDependency(compositionDep, newElement);
                }
                modelFactory.deleteElement(newElement);
                return;
            }
            if (this.getContext().getStereotype() != null && newElement instanceof IModelElement) {
                ((IModelElement)newElement).addExtension(this.getContext().getStereotype());
            }
            if (newElement instanceof IBpmnFlowElement && this.getParentNode().getRelatedIElement() instanceof IBpmnLane) {
                IBpmnLane lane = (IBpmnLane)this.getParentNode().getRelatedIElement();
                IBpmnFlowElement flowElement = (IBpmnFlowElement)newElement;
                lane.addFlowElementRef(flowElement);
            }
            DefaultNameFactory.setDefaultName((IModelElement)((IModelElement)newElement));
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            elementInitializer.initialize(newElement, this.getContext().getProperties());
        }
        diagram.unmask(this.getParentNode(), newElement, this.getConstraint());
    }
}

