/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IProjectListener;
import com.modeliosoft.modelio.internal.app.impl.ProjectService;
import com.modeliosoft.modelio.internal.app.impl.events.IProjectService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;

public class ProjectService
implements IProjectService {
    private final List<IProjectListener> listeners = new ArrayList();
    private final List<IModelingSession> openedSessions = new ArrayList();
    private static final String PROJECTLISTENER_EXTENSION_ID = "org.modelio.project.listeners";
    private static ProjectService instance = new ProjectService();

    private ProjectService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(IProjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        ProjectService projectService = this;
        synchronized (projectService) {
            this.listeners.add(listener);
            for (IModelingSession session : this.openedSessions) {
                listener.modelOpened(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireModelClosed(IModelingSession session) {
        ProjectService projectService = this;
        synchronized (projectService) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PROJECTLISTENER_EXTENSION_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IProjectListener) {
                        1 runnable = new /* Unavailable Anonymous Inner Class!! */;
                        SafeRunner.run((ISafeRunnable)runnable);
                    }
                    ++n2;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            for (IProjectListener l : new ArrayList(this.listeners)) {
                l.modelClosed(session);
            }
            this.openedSessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireModelOpened(IModelingSession session) {
        ProjectService projectService = this;
        synchronized (projectService) {
            this.openedSessions.add(session);
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PROJECTLISTENER_EXTENSION_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IProjectListener) {
                        2 runnable = new /* Unavailable Anonymous Inner Class!! */;
                        SafeRunner.run((ISafeRunnable)runnable);
                    }
                    ++n2;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            for (IProjectListener l : new ArrayList(this.listeners)) {
                l.modelOpened(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(IProjectListener listener) {
        ProjectService projectService = this;
        synchronized (projectService) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectOpened(IProject project) {
        ProjectService projectService = this;
        synchronized (projectService) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PROJECTLISTENER_EXTENSION_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IProjectListener) {
                        3 runnable = new /* Unavailable Anonymous Inner Class!! */;
                        SafeRunner.run((ISafeRunnable)runnable);
                    }
                    ++n2;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            for (IProjectListener l : new ArrayList(this.listeners)) {
                l.projectOpened(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectClosed(IProject project) {
        ProjectService projectService = this;
        synchronized (projectService) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PROJECTLISTENER_EXTENSION_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IProjectListener) {
                        4 runnable = new /* Unavailable Anonymous Inner Class!! */;
                        SafeRunner.run((ISafeRunnable)runnable);
                    }
                    ++n2;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            for (IProjectListener l : new ArrayList(this.listeners)) {
                l.projectClosed(project);
            }
        }
    }

    public static ProjectService getInstance() {
        return instance;
    }
}

