/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.editors.history;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.model.change.IElementDeletedEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.diagram.editor.DiagramEditorInput;
import com.modeliosoft.modelio.edition.texteditors.OEditorInput;
import com.modeliosoft.modelio.internal.app.impl.editors.history.EditorNextLocationAction;
import com.modeliosoft.modelio.internal.app.impl.editors.history.EditorPreviousLocationAction;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.util.LinkedList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EditorLocationHistory
implements IModelChangeListener,
IPartListener {
    protected EditorPreviousLocationAction previousLocationAction;
    protected EditorNextLocationAction nextLocationAction;
    protected LinkedList<IEditorInput> navigationHistory = new LinkedList();
    private ToolBarManager toolbarManager = null;
    private int activeEntry = -1;

    public EditorLocationHistory() {
        this.makeActions();
    }

    protected void handleSelection(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (this.navigationHistory.size() == 0 || this.navigationHistory.size() > 0 && this.navigationHistory.lastIndexOf(editorInput) == -1) {
            this.addElement(editorInput);
        }
        this.activeEntry = this.navigationHistory.lastIndexOf(editorInput);
        this.updateActions();
    }

    private void addElement(IEditorInput element) {
        if (this.navigationHistory.size() == 20) {
            this.navigationHistory.removeFirst();
        }
        this.navigationHistory.offerLast(element);
    }

    public void selectPreviousSelection() {
        IEditorInput editorInput;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        if (this.hasPrevious() && (editorInput = (IEditorInput)this.navigationHistory.get(this.activeEntry - 1)) != null) {
            if (editorInput instanceof DiagramEditorInput) {
                IAbstractDiagram diagram = ((DiagramEditorInput)editorInput).getDiagram();
                if (diagram != null && diagram.isValid()) {
                    O.getDefault().getActivationService().fireActivate((IElement)diagram);
                } else {
                    this.navigationHistory.remove(this.activeEntry - 1);
                }
            } else if (editorInput instanceof OEditorInput) {
                OEditorInput textInput = (OEditorInput)editorInput;
                Modelio.getInstance().getEditionService().openEditor(textInput.getModelElement(), textInput.getFile(), textInput.getEditorTypeID(), !textInput.isModifiable());
            }
            --this.activeEntry;
        }
        this.updateActions();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
    }

    public void selectNextSelection() {
        IEditorInput editorInput;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        if (this.hasNext() && (editorInput = (IEditorInput)this.navigationHistory.get(this.activeEntry + 1)) != null) {
            if (editorInput instanceof DiagramEditorInput) {
                IAbstractDiagram diagram = ((DiagramEditorInput)editorInput).getDiagram();
                if (diagram != null && diagram.isValid()) {
                    O.getDefault().getActivationService().fireActivate((IElement)diagram);
                } else {
                    this.navigationHistory.remove(this.activeEntry + 1);
                    --this.activeEntry;
                }
            } else if (editorInput instanceof OEditorInput) {
                OEditorInput textInput = (OEditorInput)editorInput;
                Modelio.getInstance().getEditionService().openEditor(textInput.getModelElement(), textInput.getFile(), textInput.getEditorTypeID(), !textInput.isModifiable());
            }
            ++this.activeEntry;
        }
        this.updateActions();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
    }

    private void removeAfter(int index) {
        while (this.navigationHistory.size() > index + 1) {
            this.navigationHistory.removeLast();
        }
    }

    private void makeActions() {
        this.makePreviousLocationAction();
        this.makeNextLocationAction();
        this.toolbarManager = new ToolBarManager(0x820000);
        this.previousLocationAction.setEnabled(false);
        this.nextLocationAction.setEnabled(false);
        this.toolbarManager.add((IAction)this.previousLocationAction);
        this.toolbarManager.add((IAction)this.nextLocationAction);
        ICoolBarManager coolbarManager = O.getDefault().getActionBars().getCoolBarManager();
        coolbarManager.add((IToolBarManager)this.toolbarManager);
    }

    private void makePreviousLocationAction() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/backward_16.png");
        String label = Messages.getString((String)"PreviousEditorSelection");
        this.previousLocationAction = new EditorPreviousLocationAction(this, label, image);
        this.previousLocationAction.setEnabled(true);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.app.EditorPreviousLocationID", (IHandler)new ActionHandler((IAction)this.previousLocationAction));
        }
    }

    private void makeNextLocationAction() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/forward_16.png");
        String label = Messages.getString((String)"NextEditorSelection");
        this.nextLocationAction = new EditorNextLocationAction(this, label, image);
        this.nextLocationAction.setEnabled(true);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.app.EditorNextLocationID", (IHandler)new ActionHandler((IAction)this.nextLocationAction));
        }
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        IElementDeletedEvent[] deletedEvents = event.getDeleteEvents();
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void start() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
    }

    public void stop() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        this.previousLocationAction.setEnabled(false);
        this.nextLocationAction.setEnabled(false);
        this.activeEntry = -1;
        this.navigationHistory.clear();
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.handleSelection((IEditorPart)part);
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public boolean hasPrevious() {
        return this.activeEntry > 0;
    }

    public boolean hasNext() {
        return this.activeEntry < this.navigationHistory.size() - 1;
    }

    public void updateActions() {
        if (this.hasPrevious()) {
            this.previousLocationAction.setEnabled(true);
        } else {
            this.previousLocationAction.setEnabled(false);
        }
        if (this.hasNext()) {
            this.nextLocationAction.setEnabled(true);
        } else {
            this.nextLocationAction.setEnabled(false);
        }
    }

    static /* synthetic */ void access$0(EditorLocationHistory editorLocationHistory, int n) {
        editorLocationHistory.activeEntry = n;
    }
}

