/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.migration;

import com.modeliosoft.modelio.core.ExmlRepository;
import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.core.app.AppInfos;
import com.modeliosoft.modelio.internal.app.impl.migration.MigrationConfirmationDialog;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio7005.Project7005Migrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio7006.Project7006Migrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio7008.Project7008Migrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio8003.Project8003Migrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio8020.Project8020Migrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio8021.Project8021Migrator;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectMigrator
implements IRunnableWithProgress {
    private File oldOfpPath;
    private File newOfpPath;
    private File projectDirectory;

    public ProjectMigrator(File projectDirectory, File ofpToMigrate, File newOfpPath) {
        this.oldOfpPath = ofpToMigrate;
        this.newOfpPath = newOfpPath;
        this.projectDirectory = projectDirectory;
    }

    public void execute(IProgressMonitor monitor) throws IOException {
        int mmVersion;
        OfpFile ofp = new OfpFile(this.oldOfpPath);
        int baseVersion = ofp.getMetamodelVersion();
        if (baseVersion > (mmVersion = AppInfos.getMetamodelVersion())) {
            throw new IOException(Messages.getMessage((String)"Migration.ModelioTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
        if (baseVersion < 7005) {
            throw new IOException(Messages.getMessage((String)"Migration.ProjectTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
        if (baseVersion == 7005) {
            new Project7005Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion == 7006) {
            new Project7006Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion == 7007) {
            new Project7006Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion == 7008) {
            new Project7008Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (8000 <= baseVersion && baseVersion < 8004) {
            new Project8003Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (8004 <= baseVersion && baseVersion < 8021) {
            new Project8020Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (8021 <= baseVersion) {
            new Project8021Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion != mmVersion) {
            throw new IOException(Messages.getMessage((String)"Migration.ProjectTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.execute(monitor);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }

    public static boolean isMigrationRequired(IBase ofp) throws IOException {
        int ofpVersion;
        try {
            ofpVersion = ofp.getMetamodelVersion();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return ofpVersion != AppInfos.getMetamodelVersion();
    }

    public static boolean isMigrationSupported(IBase ofp) throws IOException {
        int mmVersion = AppInfos.getMetamodelVersion();
        int ofpVersion = ofp.getMetamodelVersion();
        if (ofp instanceof ExmlRepository) {
            System.out.println("Exml repository, not yet implemented.");
            return false;
        }
        if (ofpVersion > mmVersion) {
            System.out.println("Modelio is too old");
            return false;
        }
        if (ofpVersion < 7005) {
            return false;
        }
        return ofpVersion < mmVersion;
    }

    public boolean askForMigration(String projectName, int baseVersion) {
        int mmVersion = AppInfos.getMetamodelVersion();
        String message = baseVersion == 7008 ? Messages.getMessage((String)"MigrationNeeded.content.7008", (String[])new String[]{projectName, String.valueOf(baseVersion), String.valueOf(mmVersion)}) : (baseVersion < 7008 ? Messages.getMessage((String)"MigrationNeeded.content.7006", (String[])new String[]{projectName, String.valueOf(baseVersion), String.valueOf(mmVersion)}) : Messages.getMessage((String)"MigrationNeeded.content.8000", (String[])new String[]{projectName, String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        return MigrationConfirmationDialog.openConfirmation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getMessage((String)"MigrationNeeded.DlgTitle", (String[])new String[0]), (String)message);
    }
}

