/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.migration.diagrams8004;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DiagramsMigrator {
    public void execute(File newPath, IProgressMonitor monitor) throws IOException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IModelingSession session = O.getDefault().openOfpBase(newPath);
        ITransactionManager tm = session.getTransactionManager();
        session.getAccessManager().setUser(0);
        ITransaction t = tm.createTransaction("Migrate diagrams");
        try {
            try {
                this.migrateDiagrams(session, (IProgressMonitor)mon.newChild(50));
                this.migrateDiagramSets(session, mon.newChild(50));
                tm.commit(t);
                t = null;
                session.save();
            }
            catch (InvalidTransactionException e) {
                t = null;
                if (t != null) {
                    tm.rollback(t);
                }
                session.close();
                mon.done();
            }
        }
        finally {
            if (t != null) {
                tm.rollback(t);
            }
            session.close();
            mon.done();
        }
    }

    private void migrateDiagramSets(IModelingSession session, SubMonitor monitor) {
        List diagramSets = session.getModel().findByClass(IDiagramSet.class);
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)diagramSets.size());
        IProject project = session.getModel().getProject();
        IDiagramSet root = project.getDiagramRoot();
        if (root == null) {
            root = session.getModelFactory().createDiagramSet();
            root.setName("Diagrams");
            project.setDiagramRoot(root);
        }
        for (IElement el : diagramSets) {
            IDiagramSet set = (IDiagramSet)el;
            if (set.getSuper() == null && set.getOwner() == null) {
                set.setSuper(root);
            }
            mon.worked(1);
        }
    }

    private void migrateDiagrams(IModelingSession session, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPackage rootPackage = session.getModel().getProject().getModel();
        List diagrams = session.getModel().findByClass(IAbstractDiagram.class);
        mon.worked(10);
        mon.setWorkRemaining((int)((double)diagrams.size() * 1.2));
        for (IElement el : diagrams) {
            IAbstractDiagram d = (IAbstractDiagram)el;
            if (d.getOrigin() == null) {
                d.setOrigin((IModelElement)rootPackage);
            }
            mon.worked(1);
        }
    }
}

