/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.migration.modelio10;

import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.core.app.AppInfos;
import com.modeliosoft.modelio.core.jni.CannotCopyRepairBaseException;
import com.modeliosoft.modelio.core.jni.CannotReadRepairBaseException;
import com.modeliosoft.modelio.internal.app.impl.migration.analyst7007.AnalystModelMigrator;
import com.modeliosoft.modelio.internal.app.impl.migration.diagrams8004.DiagramsMigrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio10.ProjectMigrator;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;

public class ProjectMigrator {
    private String lang = Locale.getDefault().getLanguage();
    private File newOfpFile;
    private File projectDirectory;
    private File xmlFullSource;
    private File xmlFullTarget;
    private File oldOfpFile;

    public ProjectMigrator(File projectDirectory, File ofpToMigrate, File projectFile) {
        this.oldOfpFile = ofpToMigrate;
        this.newOfpFile = projectFile;
        this.projectDirectory = projectDirectory;
        this.xmlFullSource = new File(projectDirectory, "old_full.xml");
        this.xmlFullTarget = new File(projectDirectory, "new_full.xml");
        if (!this.lang.equals("fr")) {
            this.lang = "en";
        }
    }

    public void execute(IProgressMonitor monitor) throws IOException {
        SubMonitor mon2 = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getMessage((String)"ProjectMigrator.Converting", (String[])new String[0]), (int)85);
        try {
            try {
                OfpFile newOfp = new OfpFile(this.newOfpFile);
                newOfp.createBase(this.newOfpFile.getName());
                OfpFile oldOfp = new OfpFile(this.oldOfpFile);
                if (oldOfp.getLockOwner() != "") {
                    oldOfp.unlock();
                }
                mon2.worked(5);
                mon2.subTask(Messages.getMessage((String)"ProjectMigrator.Exporting", (String[])new String[0]));
                this.externalizeOfp(this.oldOfpFile);
                mon2.worked(20);
                mon2.subTask(Messages.getMessage((String)"ProjectMigrator.Translating", (String[])new String[0]));
                this.runXslt(this.xmlFullSource, this.xmlFullTarget);
                mon2.worked(20);
                mon2.subTask(Messages.getMessage((String)"ProjectMigrator.Importing", (String[])new String[0]));
                this.internalizeOfp(this.xmlFullTarget, this.newOfpFile);
                mon2.worked(20);
                mon2.subTask(Messages.getMessage((String)"ProjectMigrator.ConvertingAnalystModel", (String[])new String[0]));
                new AnalystModelMigrator(this.projectDirectory, this.newOfpFile).execute((IProgressMonitor)mon2.newChild(10));
                mon2.subTask(Messages.getMessage((String)"ProjectMigrator.UpdatingDiagrams", (String[])new String[0]));
                new DiagramsMigrator().execute(this.newOfpFile, (IProgressMonitor)mon2.newChild(10));
            }
            catch (CannotCopyRepairBaseException e1) {
                throw new IOException(e1.getLocalizedMessage(), e1);
            }
            catch (CannotReadRepairBaseException e1) {
                throw new IOException(e1.getLocalizedMessage(), e1);
            }
        }
        finally {
            mon2.done();
        }
    }

    private File getResourcePath(String relativePath) throws IOException {
        Path iPath = new Path(relativePath);
        Bundle bundle = Platform.getBundle((String)"org.modelio.core");
        URL pluginUrl = FileLocator.find((Bundle)bundle, (IPath)iPath, null);
        if (pluginUrl == null) {
            throw new FileNotFoundException(Messages.getMessage((String)"ProjectMigrator.ResFileNotFound", (String[])new String[]{iPath.toOSString(), bundle.getSymbolicName()}));
        }
        URL url = FileLocator.toFileURL((URL)pluginUrl);
        return new File(url.getPath());
    }

    private void internalizeOfp(File xmlPath, File ofpFile) throws IOException {
        File exePath = this.getResourcePath("/lib/internalizeXml.exe");
        File clientPath = this.getResourcePath("");
        File logFile = new File(this.projectDirectory, "migration.log");
        ArrayList<String> params = new ArrayList<String>();
        params.add(exePath.getPath());
        params.add("-clientpath");
        params.add(clientPath.getPath());
        params.add("-lang");
        params.add(this.lang);
        params.add("-version");
        params.add(AppInfos.getVersion().toString());
        params.add("-console");
        params.add(logFile.getPath());
        this.addBreakFlag(params, "internalizeXml.break");
        params.add(xmlPath.getPath());
        params.add(ofpFile.getPath());
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        try {
            OutputBuilder processOut = new OutputBuilder(this, p.getInputStream());
            int res = p.waitFor();
            processOut.close();
            if (res != 0) {
                throw new IOException(Messages.getMessage((String)"ProjectMigrator.ImportFailed", (String[])new String[]{processOut.get(), logFile.getPath()}));
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void runXslt(File xmlSource, File xmlTarget) throws IOException {
        if (!xmlSource.canRead()) {
            throw new FileNotFoundException(Messages.getMessage((String)"ProjectMigrator.FileNotFound", (String[])new String[]{xmlSource.getPath()}));
        }
        File utilPath = this.getResourcePath("/lib/xalan.exe");
        File xsltFile = this.getResourcePath("/res/common/update/modelio1.0/project.xslt");
        File logFile = new File(this.projectDirectory, "migration.log");
        ProcessBuilder builder = new ProcessBuilder(utilPath.getPath(), "-t", "-o", xmlTarget.getPath(), xmlSource.getPath(), xsltFile.getPath());
        builder.redirectErrorStream(true);
        OutputBuilder processOut = null;
        FileWriter w = new FileWriter(logFile, true);
        try {
            try {
                Process p = builder.start();
                processOut = new OutputBuilder(this, p.getInputStream());
                int res = p.waitFor();
                if (res != 0) {
                    throw new IOException(Messages.getMessage((String)"ProjectMigrator.TranslationFailed", (String[])new String[]{processOut.get(), logFile.getPath()}));
                }
                if (!xmlTarget.canRead()) {
                    throw new FileNotFoundException(Messages.getMessage((String)"ProjectMigrator.FileNotFound", (String[])new String[]{xmlTarget.getPath()}));
                }
            }
            catch (InterruptedException e) {
                w.append(e.getMessage());
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            if (processOut != null) {
                w.append(processOut.get());
            }
            w.close();
        }
    }

    private void externalizeOfp(File ofpToDump) throws IOException {
        File exePath = this.getResourcePath("/lib/modelio1.0/externalizeBase.exe");
        File clientPath = this.getResourcePath("");
        File logFile = new File(this.projectDirectory, "migration.log");
        String newVersion = AppInfos.getVersion().toString();
        ArrayList<String> params = new ArrayList<String>();
        params.add(exePath.getPath());
        this.addBreakFlag(params, "externalizeBase.break");
        params.add("-version");
        params.add(newVersion);
        params.add("-console");
        params.add(logFile.getPath());
        params.add("-clientpath");
        params.add(clientPath.getPath());
        params.add("-lang");
        params.add(this.lang);
        params.add(ofpToDump.getPath());
        params.add(this.projectDirectory.getPath());
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        try {
            OutputBuilder processOut = new OutputBuilder(this, p.getInputStream());
            int res = p.waitFor();
            if (res != 0) {
                throw new IOException(Messages.getMessage((String)"ProjectMigrator.ExportFailed", (String[])new String[]{String.valueOf(res), processOut.get(), logFile.getPath()}));
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void addBreakFlag(ArrayList<String> to, String relativePath) {
        File aFile = new File(this.projectDirectory, relativePath);
        if (aFile.isFile()) {
            to.add("-break");
        }
    }
}

