/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.migration.modelio7006;

import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.internal.app.impl.migration.analyst7007.AnalystModelMigrator;
import com.modeliosoft.modelio.internal.app.impl.migration.diagrams8004.DiagramsMigrator;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Project7006Migrator {
    private String lang = Locale.getDefault().getLanguage();
    private File newOfpFile;
    private File oldOfpFile;
    private File projectDirectory;

    public Project7006Migrator(File projectDirectory, File ofpToMigrate, File projectFile) {
        this.oldOfpFile = ofpToMigrate;
        this.newOfpFile = projectFile;
        this.projectDirectory = projectDirectory;
        if (!this.lang.equals("fr")) {
            this.lang = "en";
        }
    }

    public void execute(IProgressMonitor monitor) throws IOException {
        SubMonitor mon2 = SubMonitor.convert((IProgressMonitor)monitor, (int)35);
        mon2.setTaskName(Messages.getMessage((String)"ProjectMigrator.Converting", (String[])new String[0]));
        try {
            if (this.newOfpFile.isFile() && !this.newOfpFile.delete()) {
                throw new IOException(Messages.getMessage((String)"CannotDeleteFile", (String[])new String[]{this.newOfpFile.getPath()}));
            }
            OfpFile oldOfp = new OfpFile(this.oldOfpFile);
            if (oldOfp.getLockOwner() != "") {
                oldOfp.unlock();
            }
            mon2.worked(5);
            mon2.subTask(Messages.getMessage((String)"ProjectMigrator.Converting", (String[])new String[0]));
            oldOfp.migrateTo(this.newOfpFile);
            mon2.worked(10);
            mon2.subTask(Messages.getMessage((String)"ProjectMigrator.ConvertingAnalystModel", (String[])new String[0]));
            new AnalystModelMigrator(this.projectDirectory, this.newOfpFile).execute((IProgressMonitor)mon2.newChild(10));
            mon2.subTask(Messages.getMessage((String)"ProjectMigrator.UpdatingDiagrams", (String[])new String[0]));
            new DiagramsMigrator().execute(this.newOfpFile, (IProgressMonitor)mon2.newChild(10));
        }
        finally {
            mon2.done();
        }
    }
}

