/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.migration.modelio7008;

import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.internal.app.impl.migration.diagrams8004.DiagramsMigrator;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Project7008Migrator {
    private String lang = Locale.getDefault().getLanguage();
    private File newOfpFile;
    private File oldOfpFile;

    public Project7008Migrator(File projectDirectory, File ofpToMigrate, File newOfpFile) {
        this.oldOfpFile = ofpToMigrate;
        this.newOfpFile = newOfpFile;
        if (!this.lang.equals("fr")) {
            this.lang = "en";
        }
    }

    public void execute(IProgressMonitor monitor) throws IOException {
        SubMonitor mon2 = SubMonitor.convert((IProgressMonitor)monitor, (int)35);
        mon2.setTaskName(Messages.getMessage((String)"ProjectMigrator.Converting", (String[])new String[0]));
        try {
            if (this.newOfpFile.isFile() && !this.newOfpFile.delete()) {
                throw new IOException(Messages.getMessage((String)"CannotDeleteFile", (String[])new String[]{this.newOfpFile.getPath()}));
            }
            OfpFile oldOfp = new OfpFile(this.oldOfpFile);
            if (oldOfp.getLockOwner() != "") {
                oldOfp.unlock();
            }
            mon2.worked(10);
            mon2.subTask(Messages.getMessage((String)"ProjectMigrator.Converting", (String[])new String[0]));
            oldOfp.migrateTo(this.newOfpFile);
            mon2.subTask(Messages.getMessage((String)"ProjectMigrator.UpdatingDiagrams", (String[])new String[0]));
            new DiagramsMigrator().execute(this.newOfpFile, (IProgressMonitor)mon2.newChild(10));
        }
        finally {
            mon2.done();
        }
    }
}

