/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.model;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.core.app.AppInfos;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkgroup;
import com.modeliosoft.modelio.internal.app.ProjectException;
import com.modeliosoft.modelio.internal.app.ProjectExceptionDiagnostic;
import com.modeliosoft.modelio.internal.app.impl.ProjectService;
import com.modeliosoft.modelio.internal.app.impl.migration.ProjectMigrator;
import com.modeliosoft.modelio.internal.app.impl.model.ProjectRepairer;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.modules.ModulesUpdater;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class Project
implements IProject {
    private IProjectSpace projectSpace = null;
    private IWorkgroup workgroup = null;
    private String name;
    private IModelingSession modelingSession;
    private static final String pluginId = "org.modelio.app.internal";

    public String getDescription() {
        return this.projectSpace.getDescription();
    }

    public Project(String projectName, String user, String pass, IProjectSpace projectSpace) {
        this.name = projectName;
        this.projectSpace = projectSpace;
        this.initWorkgroup(projectSpace);
    }

    private void initWorkgroup(IProjectSpace aProjectSpace) {
    }

    public void close() {
        try {
            new MdacManager(this.modelingSession).stopAllModules();
        }
        catch (MdacException e) {
            e.printStackTrace();
        }
        ProjectService.getInstance().fireModelClosed(this.modelingSession);
        O.getDefault().closeProject(this.modelingSession);
        this.modelingSession = null;
        ProjectService.getInstance().fireProjectClosed((IProject)this);
    }

    public IModelingSession getSession() {
        return this.modelingSession;
    }

    public void open(IProgressMonitor monitor) throws ProjectException {
        boolean modulesUpdateNeeded;
        SubMonitor progress;
        block18: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            progress.subTask(Messages.getMessage((String)"ModelOpening", (String[])new String[0]));
            modulesUpdateNeeded = false;
            try {
                IBase ofp = this.projectSpace.getDatabase();
                if (!ofp.getLockOwner().equals("")) {
                    boolean ok = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getMessage((String)"ProjectLocked", (String[])new String[0]), (String)Messages.getMessage((String)"UnlockProject", (String[])new String[]{this.getName(), ofp.getLockOwner().trim()}));
                    if (ok) {
                        ofp.unlock();
                    } else {
                        throw new ProjectException(ProjectExceptionDiagnostic.LockedProject, Messages.getMessage((String)"ProjectLocked", (String[])new String[0]));
                    }
                }
                try {
                    if (ProjectMigrator.isMigrationRequired((IBase)ofp)) {
                        progress.subTask(Messages.getString((String)"ModelMigrating"));
                        this.migrate(ofp);
                        modulesUpdateNeeded = true;
                    }
                }
                catch (IOException e) {
                    if (ofp instanceof OfpFile) {
                        try {
                            new ProjectRepairer((OfpFile)ofp).repair();
                            break block18;
                        }
                        catch (IOException ioe) {
                            throw new ProjectException(ProjectExceptionDiagnostic.CorruptedContents, ioe.getMessage());
                        }
                    }
                    throw e;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new ProjectException(ProjectExceptionDiagnostic.IOError, e1.getLocalizedMessage());
            }
        }
        File projectDir = this.projectSpace.getDataDirectory();
        IBase ofpFile = this.projectSpace.getDatabase();
        IModelingSession session = null;
        try {
            session = O.getDefault().openProject(projectDir, ofpFile.getFile().getName());
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.equals("The project is not compatible with the current edition.")) {
                throw new ProjectException(ProjectExceptionDiagnostic.EditionIncompatibility, message);
            }
            if (ofpFile instanceof OfpFile) {
                try {
                    new ProjectRepairer((OfpFile)ofpFile).repair();
                    session = O.getDefault().openProject(projectDir, ofpFile.getFile().getName());
                }
                catch (IOException ioe) {
                    throw new ProjectException(ProjectExceptionDiagnostic.CorruptedContents, ioe.getMessage());
                }
            }
            throw new ProjectException((Throwable)e);
        }
        this.modelingSession = session;
        ProjectService.getInstance().fireModelOpened(session);
        progress.worked(50);
        File mdaDir = new File(this.projectSpace.getDataDirectory(), "mda");
        File mdaRuntimeDir = new File(mdaDir, ".runtime");
        this.projectSpace.delete(mdaRuntimeDir);
        if (modulesUpdateNeeded) {
            this.updateModules(this.modelingSession);
        }
        progress.worked(10);
        progress.subTask("Starting modules...");
        new MdacManager(session).startAllModules((IProgressMonitor)progress.newChild(40));
        ProjectService.getInstance().fireProjectOpened((IProject)this);
    }

    public IProjectSpace getProjectSpace() {
        return this.projectSpace;
    }

    public IWorkgroup getWorkgroup() {
        return null;
    }

    private void migrate(IBase ofp) throws ProjectException {
        block18: {
            int baseVersion;
            try {
                baseVersion = ofp.getMetamodelVersion();
            }
            catch (IOException e1) {
                throw new ProjectException(ProjectExceptionDiagnostic.IOError, e1.getLocalizedMessage());
            }
            int mmVersion = AppInfos.getMetamodelVersion();
            File migratedOfpFile = ofp.getFile();
            File oldOfpPath = new File(String.valueOf(migratedOfpFile.getPath()) + ".old");
            File buggyOfpPath = new File(String.valueOf(ofp.getFile().getPath()) + ".failed");
            ProjectMigrator m = new ProjectMigrator(this.projectSpace.getDataDirectory(), oldOfpPath, migratedOfpFile);
            boolean ok = m.askForMigration(this.getName(), baseVersion);
            if (ok) {
                if (buggyOfpPath.isFile() && !buggyOfpPath.delete()) {
                    throw new ProjectException(ProjectExceptionDiagnostic.IOError, Messages.getMessage((String)"CannotDeleteFile", (String[])new String[]{buggyOfpPath.getPath()}));
                }
                if (oldOfpPath.isFile() && !oldOfpPath.delete()) {
                    throw new ProjectException(ProjectExceptionDiagnostic.IOError, Messages.getMessage((String)"CannotDeleteFile", (String[])new String[]{oldOfpPath.getPath()}));
                }
                if (!ofp.getFile().renameTo(oldOfpPath)) {
                    throw new ProjectException(ProjectExceptionDiagnostic.IOError, Messages.getMessage((String)"CannotRenameFile", (String[])new String[]{migratedOfpFile.getPath(), oldOfpPath.getPath()}));
                }
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                boolean success = false;
                try {
                    try {
                        service.busyCursorWhile((IRunnableWithProgress)m);
                        success = true;
                        break block18;
                    }
                    catch (InvocationTargetException e) {
                        try {
                            throw e.getCause();
                        }
                        catch (IOException e2) {
                            throw new ProjectException(ProjectExceptionDiagnostic.IOError, e2.getLocalizedMessage());
                        }
                        catch (RuntimeException e2) {
                            throw new ProjectException((Throwable)e2);
                        }
                        catch (Error e2) {
                            throw new ProjectException((Throwable)e2);
                        }
                        catch (Throwable e2) {
                            throw new ProjectException(e2);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new ProjectException((Throwable)e);
                    }
                }
                finally {
                    if (!(success || migratedOfpFile.isFile() && !migratedOfpFile.renameTo(buggyOfpPath))) {
                        oldOfpPath.renameTo(migratedOfpFile);
                    }
                }
            }
            throw new ProjectException(ProjectExceptionDiagnostic.IncompatibleMetamodelVersion, Messages.getMessage((String)"MigrationNeeded.CancelledError", (String[])new String[]{this.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
    }

    public boolean isDirty() {
        assert (this.modelingSession != null);
        return this.modelingSession.isDirty();
    }

    public void save() {
        assert (this.modelingSession != null);
        this.modelingSession.save();
    }

    public String getName() {
        return this.name;
    }

    private String updateModules(IModelingSession session) {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        ModulesUpdater modulesUpdater = new ModulesUpdater(session);
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        LOG.info((String)pluginId, (String)modulesUpdater.getReport());
        session.save();
        return modulesUpdater.getReport();
    }

    @Deprecated
    public void open() throws ProjectException {
        this.open((IProgressMonitor)new NullProgressMonitor());
    }
}

