/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules.ModulePreferenceNode;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModelioPreferenceDialog
extends PreferenceDialog {
    private static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    private int _messageLabelHeight;
    private boolean _titleImageLargest;
    private String _message;
    private Collection<IMdac> mdacs;
    private ITransaction transaction = null;
    private ITransactionManager transactionManager = null;
    private ArrayList<IPreferenceNode> nodes;
    private Composite _titleArea;
    Color _titleAreaColor;
    private RGB _titleAreaRGB;
    private Label _titleRightImageLabel;
    private Image _titleLeftImage;
    private Label _titleLeftImageLabel;
    private Image _titleRightImage;
    private Label _titleLabel;
    private Text _messageLabel;
    private Label _messageImageLabel;
    private Label _leftFillerLabel;

    public ModelioPreferenceDialog(Shell parentShell, IModelingSession modelingSession) {
        super(parentShell, PlatformUI.getWorkbench().getPreferenceManager());
        this.mdacs = modelingSession.getMdacRegistry().getStartedMdacs();
        this.transactionManager = modelingSession.getTransactionManager();
        this._message = "";
        PreferenceManager preferenceManager = this.getPreferenceManager();
        preferenceManager.remove("org.eclipse.ui.preferencePages.Workbench");
        preferenceManager.remove("org.eclipse.help.ui.browsersPreferencePage");
        this.nodes = new ArrayList();
        for (IMdac mdac : this.mdacs) {
            if (mdac.getName().equals("LocalModule") || mdac.getConfiguration().getParameters().size() <= 0) continue;
            ModulePreferenceNode node = new ModulePreferenceNode(modelingSession, mdac);
            this.nodes.add(node);
            preferenceManager.addToRoot((IPreferenceNode)node);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean close() {
        block8: {
            block7: {
                try {
                    try {
                        this.transactionManager.commit(this.transaction);
                        this.transaction = null;
                        break block7;
                    }
                    catch (InvalidTransactionException e) {
                        LOG.error((String)"org.modelio.app.internal", (Throwable)e);
                        this.transaction = null;
                        this.rollbackTransaction();
                        ** for (node : this.nodes)
                    }
                }
                catch (Throwable var2_8) {
                    this.rollbackTransaction();
                    ** for (node : this.nodes)
                }
lbl-1000:
                // 1 sources

                {
                    this.getPreferenceManager().remove(node);
                    continue;
lbl14:
                    // 1 sources

                    break block8;
                }
lbl-1000:
                // 1 sources

                {
                    this.getPreferenceManager().remove(node);
                    continue;
                }
lbl21:
                // 1 sources

                throw var2_8;
            }
            this.rollbackTransaction();
            for (IPreferenceNode node : this.nodes) {
                this.getPreferenceManager().remove(node);
            }
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.createTitle(parent);
        this.setTitle(Messages.getString((String)"ParametersDlg.Title"));
        this.setDialogMessage(Messages.getString((String)"ParametersDlg.Desc"));
        this.getShell().setMinimumSize(700, 500);
        parent.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.transaction = this.transactionManager.createTransaction("Save Modelio preferences");
        parent.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        return super.createDialogArea(parent);
    }

    protected void setTitleLeftImage(Image newTitleImage) {
        this._titleLeftImage = newTitleImage;
        if (this._titleLeftImageLabel != null && !this._titleLeftImageLabel.isDisposed()) {
            this._titleLeftImageLabel.setImage(newTitleImage);
            this._titleLeftImageLabel.setVisible(newTitleImage != null);
        }
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this._titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this._titleRightImageLabel);
        messageLabelData.left = new FormAttachment((Control)this._messageImageLabel, horizontalSpacing);
        if (!this._titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this._titleRightImageLabel, 0, 1024);
        }
        this._messageLabel.setLayoutData((Object)messageLabelData);
        FormData imageLabelData = new FormData();
        imageLabelData.top = new FormAttachment((Control)this._titleLabel, verticalSpacing);
        imageLabelData.left = new FormAttachment((Control)this._titleLeftImageLabel);
        this._messageImageLabel.setLayoutData((Object)imageLabelData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this._titleLabel, 0, 128);
        data.left = new FormAttachment((Control)this._titleLeftImageLabel);
        data.bottom = new FormAttachment((Control)this._messageLabel, 0, 1024);
        this._leftFillerLabel.setLayoutData((Object)data);
    }

    private void determineTitleImageLargest() {
        int titleY = this._titleLeftImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int labelY = this._titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this._messageLabelHeight;
        this._titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void createTitle(Composite parent) {
        Color foreground;
        Color background;
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ui", (String)"icons/headerLeft.png");
        Image image = imageDescriptor.createImage();
        this.setTitleLeftImage(image);
        this._titleArea = new Composite(parent, 0);
        this.initializeDialogUnits((Control)this._titleArea);
        GridData titleAreaData = new GridData(4, 128, true, false);
        this._titleArea.setLayoutData((Object)titleAreaData);
        FormLayout layout = new FormLayout();
        this._titleArea.setLayout((Layout)layout);
        this._titleArea.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Display display = this._titleArea.getDisplay();
        if (this._titleAreaRGB != null) {
            background = this._titleAreaColor = new Color((Device)display, this._titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this._titleArea.setBackground(background);
        this._titleRightImageLabel = new Label(this._titleArea, 0);
        this._titleRightImageLabel.setBackground(background);
        if (this._titleRightImage != null && !this._titleRightImage.isDisposed()) {
            this._titleRightImageLabel.setImage(this._titleRightImage);
        }
        this._titleLeftImageLabel = new Label(this._titleArea, 0);
        this._titleLeftImageLabel.setBackground(background);
        if (this._titleLeftImage == null || this._titleLeftImage.isDisposed()) {
            this._titleLeftImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_BANNER));
        } else {
            this._titleLeftImageLabel.setImage(this._titleLeftImage);
        }
        FormData rightImageData = new FormData();
        rightImageData.top = new FormAttachment(0, 0);
        rightImageData.right = new FormAttachment(100, 0);
        this._titleRightImageLabel.setLayoutData((Object)rightImageData);
        FormData leftImageData = new FormData();
        leftImageData.top = new FormAttachment(0, 0);
        leftImageData.left = new FormAttachment(0, 0);
        this._titleLeftImageLabel.setLayoutData((Object)leftImageData);
        this._titleLabel = new Label(this._titleArea, 0);
        JFaceColors.setColors((Control)this._titleLabel, (Color)foreground, (Color)background);
        this._titleLabel.setFont(JFaceResources.getBannerFont());
        this._titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.left = new FormAttachment((Control)this._titleLeftImageLabel, 5);
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this._titleRightImageLabel, -5);
        this._titleLabel.setLayoutData((Object)titleData);
        this._messageImageLabel = new Label(this._titleArea, 0);
        this._messageImageLabel.setBackground(background);
        this._messageLabel = new Text(this._titleArea, 10);
        this._messageLabel.setEnabled(false);
        this._messageLabel.setEditable(false);
        JFaceColors.setColors((Control)this._messageLabel, (Color)foreground, (Color)background);
        this._messageLabel.setFont(JFaceResources.getDialogFont());
        this._messageLabelHeight = this._messageLabel.computeSize((int)-1, (int)-1).y;
        this._leftFillerLabel = new Label(this._titleArea, 0);
        this._leftFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        Label titleBarSeparator = new Label(parent, 258);
        GridData barData = new GridData(768);
        titleBarSeparator.setLayoutData((Object)barData);
    }

    protected void setTitle(String newTitle) {
        if (this._titleLabel == null) {
            return;
        }
        String title = newTitle;
        if (title == null) {
            title = "";
        }
        this._titleLabel.setText(title);
    }

    private void setDialogMessage(String newMessage) {
        if (this._message.equals(newMessage)) {
            return;
        }
        this._message = newMessage;
        if (this._message == null) {
            this._message = "";
        }
        this._messageLabel.setText(newMessage);
        this.layoutForNewMessage();
    }

    private void layoutForNewMessage() {
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        if (this.dialogArea != null) {
            this._titleArea.layout(true);
        }
    }

    void rollbackTransaction() {
        if (this.transaction != null) {
            try {
                this.transactionManager.rollback(this.transaction);
                this.transaction = null;
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.app.internal", (Throwable)e);
            }
        }
    }
}

