/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences.general;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.IProjectPropertiesService;
import com.modeliosoft.modelio.internal.app.impl.preferences.general.GeneralModel;
import com.modeliosoft.modelio.internal.app.impl.preferences.general.GeneralPreferencePage;
import com.modeliosoft.modelio.internal.app.impl.preferences.general.IPreferencesModel;
import com.modeliosoft.modelio.internal.app.impl.preferences.general.KTableGeneralModel;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.PreferenceData;
import com.modeliosoft.modelio.internal.app.services.App;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellSelectionListener;
import de.kupzog.ktable.KTableModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private KTableGeneralModel preferencesModel = null;
    private List<PreferenceData> data = null;
    private IModelingSession modelingSession = null;
    private KTable table = null;
    private Text descriptionText = null;
    private ScrolledComposite scrolledComposite = null;

    protected Control createContents(Composite parent) {
        this.createTableViewer(parent);
        this.createDescription(parent);
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    public GeneralPreferencePage() {
        this.noDefaultAndApplyButton();
        this.modelingSession = App.getInstance().getOpenedProject().getSession();
    }

    public GeneralPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
        this.noDefaultAndApplyButton();
        this.modelingSession = App.getInstance().getOpenedProject().getSession();
    }

    public GeneralPreferencePage(String title) {
        super(title);
        this.noDefaultAndApplyButton();
        this.modelingSession = App.getInstance().getOpenedProject().getSession();
    }

    private void createTableViewer(Composite parent) {
        int tableStyle = 200448;
        this.table = new KTable(parent, tableStyle);
        GridData tableData = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)tableData);
        this.initPreferences();
        this.preferencesModel = new KTableGeneralModel(this.table, (IPreferencesModel)new GeneralModel(this.modelingSession, this.data));
        this.table.setModel((KTableModel)this.preferencesModel);
        this.table.setSelection(0, 1, true);
    }

    private void initPreferences() {
        IProjectPropertiesService propertiesService = this.modelingSession.getProjectPropertiesService();
        this.data = new ArrayList();
        String key = null;
        String value = null;
        key = "Preferences.Option";
        value = "Preferences.Option";
        this.data.add(new PreferenceData(key, value));
        key = "Preferences.Attribute.DefaultType";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
        key = "Preferences.Attribute.DefaultVisibility";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
        key = "Preferences.IOParameter.DefaultType";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
        key = "Preferences.ReturnParameter.DefaultType";
        value = propertiesService.readProperty("Modelio", key);
        this.data.add(new PreferenceData(key, value));
    }

    private void createDescription(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        GridLayout gl_scrolledComposite = new GridLayout(1, false);
        this.scrolledComposite.setLayout((Layout)gl_scrolledComposite);
        this.descriptionText = new Text((Composite)this.scrolledComposite, 66);
        this.descriptionText.setEditable(false);
        this.descriptionText.setForeground(UIColor.LABEL_TIP_FG);
        GridData gd_descriptionText = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        this.scrolledComposite.setContent((Control)this.descriptionText);
        Point point = parent.getSize();
        this.scrolledComposite.setMinSize(point);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        GridData gd_scrolledComposite = new GridData(4, 1024, true, false);
        gd_scrolledComposite.heightHint = 80;
        gd_scrolledComposite.widthHint = 400;
        this.scrolledComposite.setLayoutData((Object)gd_scrolledComposite);
        this.table.addCellSelectionListener((KTableCellSelectionListener)new TableSelectionListener(this, null));
    }

    public boolean performOk() {
        IProjectPropertiesService propertiesService = this.modelingSession.getProjectPropertiesService();
        String key = null;
        String value = null;
        for (PreferenceData pref : this.data) {
            key = pref.getKey();
            value = pref.getValue();
            propertiesService.writeProperty("Modelio", key, value);
        }
        return super.performOk();
    }

    static /* synthetic */ KTableGeneralModel access$0(GeneralPreferencePage generalPreferencePage) {
        return generalPreferencePage.preferencesModel;
    }

    static /* synthetic */ Text access$1(GeneralPreferencePage generalPreferencePage) {
        return generalPreferencePage.descriptionText;
    }
}

