/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences.general;

import com.modeliosoft.modelio.internal.app.impl.preferences.general.IPreferencesModel;
import com.modeliosoft.modelio.internal.app.impl.preferences.ktable.editors.OptionEditorFactory;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.renderers.OptionRendererFactory;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.types.IOptionType;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableDefaultModel;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class KTableGeneralModel
extends KTableDefaultModel {
    private IPreferencesModel data = null;
    private Color oddColor = null;
    private Color evenColor = null;
    private KTable table = null;

    public KTableGeneralModel(KTable table, IPreferencesModel dataModel) {
        this.table = table;
        this.data = dataModel;
        this.oddColor = new Color((Device)Display.getCurrent(), new RGB(245, 255, 255));
        this.evenColor = new Color((Device)Display.getCurrent(), new RGB(230, 240, 255));
    }

    public KTableCellEditor doGetCellEditor(int col, int row) {
        KTableCellEditor editor = null;
        if (row <= 0) {
            return null;
        }
        if (col <= 0) {
            return null;
        }
        if (!this.data.isEditable(row, col)) {
            return null;
        }
        IOptionType type = this.data.getTypeAt(row, col);
        if (type == null) {
            return null;
        }
        OptionEditorFactory editorfactory = new OptionEditorFactory();
        editor = editorfactory.getEditor(type);
        return editor;
    }

    public KTableCellRenderer doGetCellRenderer(int col, int row) {
        DefaultCellRenderer renderer = null;
        OptionRendererFactory rendererfactory = new OptionRendererFactory();
        if (row == 0) {
            return rendererfactory.getHeaderRenderer();
        }
        if (col == 0) {
            renderer = rendererfactory.getLabelRenderer();
        } else {
            IOptionType type = this.data.getTypeAt(row, col);
            if (type == null) {
                return null;
            }
            renderer = rendererfactory.getRenderer(type);
        }
        renderer.setBackground(row % 2 == 0 ? this.oddColor : this.evenColor);
        return renderer;
    }

    public int doGetColumnCount() {
        return 2;
    }

    public Object doGetContentAt(int col, int row) {
        Object value = this.data.getValueAt(row, col);
        return Messages.getString((String)value.toString());
    }

    public int doGetRowCount() {
        return this.data.getRowsNumber();
    }

    public void doSetContentAt(int col, int row, Object value) {
        if (row == 0) {
            return;
        }
        if (col == 0) {
            return;
        }
        this.data.setValueAt(row, col, value);
        this.table.redraw();
    }

    public int getInitialColumnWidth(int column) {
        double firstColumnWeight = 0.35;
        int colCount = 2;
        int availableWidth = this.table.getClientArea().width - 18;
        if (column == 0) {
            return (int)((double)availableWidth * 0.35);
        }
        return (int)((double)availableWidth * 0.65) / (colCount - 1);
    }

    public int getInitialRowHeight(int row) {
        return row == 0 ? 22 : 18;
    }

    public int getFixedHeaderColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 0;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public boolean isColumnResizable(int col) {
        return true;
    }

    public void setColumnWidth(int col, int value) {
        super.setColumnWidth(col, value);
    }

    public boolean isRowResizable(int row) {
        return false;
    }

    public int getColumnWidth(int col) {
        return super.getColumnWidth(col);
    }

    public String doGetDescription(int row) {
        String descriptionKey = this.data.getDescriptionKey(row);
        if (descriptionKey != null) {
            return Messages.getString((String)descriptionKey);
        }
        return "";
    }
}

