/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences.general;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.IProjectPropertiesService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PreferencesStore {
    private IModelingSession modelingSession = null;
    private Map<String, String> properties = null;

    public PreferencesStore(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        this.properties = new HashMap();
        this.load();
    }

    private void load() {
        IProjectPropertiesService propertiesService = this.modelingSession.getProjectPropertiesService();
        this.properties.put("ParametersDlg.AttributeCreationDefaultType", propertiesService.readProperty("Modelio", "ParametersDlg.AttributeCreationDefaultType"));
        this.properties.put("ParametersDlg.AttributeCreationDefaultVisibility", propertiesService.readProperty("Modelio", "ParametersDlg.AttributeCreationDefaultVisibility"));
        this.properties.put("ParametersDlg.ParameterCreationDefaultType", propertiesService.readProperty("Modelio", "ParametersDlg.ParameterCreationDefaultType"));
        this.properties.put("ParametersDlg.ReturnParameterCreationDefaultType", propertiesService.readProperty("Modelio", "ParametersDlg.ReturnParameterCreationDefaultType"));
    }

    public void save() {
        IProjectPropertiesService propertiesService = this.modelingSession.getProjectPropertiesService();
        Set keys = this.properties.keySet();
        String value = null;
        for (String key : keys) {
            value = (String)this.properties.get(key);
            propertiesService.writeProperty("Modelio", key, value);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }
}

