/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IParameterGroupModel;
import com.modeliosoft.modelio.api.mdac.IParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.BoolParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.ColorParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.DirectoryParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.EnumParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.FileParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.PasswordParameterModel;
import com.modeliosoft.modelio.api.mdac.paramEdition.StringParameterModel;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.editors.ComboCellEditor;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.editors.DirectoryCellEditor;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.editors.FileCellEditor;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.editors.PasswordCellEditor;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.ktable.editors.TextCellEditor;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules.MdacPreferenceStore;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableDefaultModel;
import de.kupzog.ktable.editors.KTableCellEditorCheckbox;
import de.kupzog.ktable.editors.KTableCellEditorText2;
import de.kupzog.ktable.renderers.CheckableCellRenderer;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import de.kupzog.ktable.renderers.FixedCellRenderer;
import de.kupzog.ktable.renderers.TextCellRenderer;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class KMdacParametersModel
extends KTableDefaultModel {
    private List<IParameterModel> parameters;
    private MdacPreferenceStore store;
    private IMdac mdac;
    private TextCellEditor passwordEditor;
    private FileCellEditor fileEditor;
    private Color oddColor = null;
    private Color evenColor = null;
    private FixedCellRenderer headerRenderer = null;
    private TextCellRenderer textRenderer = null;
    private TextCellRenderer labelRenderer = null;
    private CheckableCellRenderer boolRenderer = null;
    private TextCellRenderer objectRenderer = null;
    private KTable table = null;
    private KTableCellEditorCheckbox boolEditor = null;
    private KTableCellEditorText2 textEditor = null;
    private DefaultCellRenderer passwordRenderer;
    private KTableCellEditor directoryEditor;

    public KMdacParametersModel(KTable table, IMdac mdac, IParameterGroupModel group, MdacPreferenceStore store) {
        this.table = table;
        this.mdac = mdac;
        mdac.getConfiguration();
        this.store = store;
        this.parameters = group.getParameters();
        this.oddColor = new Color((Device)Display.getCurrent(), new RGB(245, 255, 255));
        this.evenColor = new Color((Device)Display.getCurrent(), new RGB(230, 240, 255));
        this.initializeRenderers();
        this.initializeEditors();
    }

    public KTableCellEditor doGetCellEditor(int col, int row) {
        KTableCellEditorCheckbox editor = null;
        if (row <= 0) {
            return null;
        }
        if (col <= 0) {
            return null;
        }
        IParameterModel paramModel = this.getParamAt(row);
        if (paramModel == null) {
            return null;
        }
        Class<?> type = paramModel.getClass();
        if (col > 0) {
            if (type == null) {
                editor = null;
            } else if (type == BoolParameterModel.class) {
                editor = this.boolEditor;
            } else if (type == StringParameterModel.class) {
                editor = this.textEditor;
            } else if (type == FileParameterModel.class) {
                FileParameterModel fileModel = (FileParameterModel)paramModel;
                this.fileEditor.setExtensions(fileModel.getAllowedExtensions(), fileModel.getAllowedExtensionLabels());
                editor = this.fileEditor;
            } else if (type == DirectoryParameterModel.class) {
                editor = this.directoryEditor;
            } else if (type == ColorParameterModel.class) {
                editor = this.textEditor;
            } else if (type == PasswordParameterModel.class) {
                editor = this.passwordEditor;
            } else if (type == EnumParameterModel.class) {
                EnumParameterModel enumType = (EnumParameterModel)paramModel;
                ComboCellEditor comboEditor = new ComboCellEditor();
                comboEditor.setItems(enumType.getLabels().toArray(new String[0]));
                editor = comboEditor;
            }
        }
        return editor;
    }

    public KTableCellRenderer doGetCellRenderer(int col, int row) {
        Object renderer = null;
        if (row == 0) {
            return this.headerRenderer;
        }
        IParameterModel paramModel = this.getParamAt(row);
        if (paramModel == null) {
            return null;
        }
        Class<?> type = paramModel.getClass();
        if (col == 0) {
            renderer = this.labelRenderer;
        } else {
            renderer = this.objectRenderer;
            renderer = type == StringParameterModel.class ? this.textRenderer : (type == BoolParameterModel.class ? this.boolRenderer : (type == EnumParameterModel.class ? this.textRenderer : (type == PasswordParameterModel.class ? this.passwordRenderer : this.textRenderer)));
        }
        renderer.setBackground(row % 2 == 0 ? this.oddColor : this.evenColor);
        return renderer;
    }

    public int doGetColumnCount() {
        return 2;
    }

    public Object doGetContentAt(int col, int row) {
        if (row == 0) {
            if (col == 0) {
                return Messages.getMessage((String)"ParametersDlg.Parameter", (String[])new String[0]);
            }
            return Messages.getMessage((String)"ParametersDlg.Value", (String[])new String[0]);
        }
        IParameterModel paramModel = this.getParamAt(row);
        if (paramModel == null) {
            return null;
        }
        if (col == 0) {
            return paramModel.getLabel();
        }
        Class<?> type = paramModel.getClass();
        if (type == BoolParameterModel.class) {
            return this.store.getBoolean(MdacPreferenceStore.getId((String)this.mdac.getName(), (String)paramModel.getName()));
        }
        if (type == EnumParameterModel.class) {
            String value = this.store.getString(MdacPreferenceStore.getId((String)this.mdac.getName(), (String)paramModel.getName()));
            return ((EnumParameterModel)paramModel).getLabel(value);
        }
        return this.store.getString(MdacPreferenceStore.getId((String)this.mdac.getName(), (String)paramModel.getName()));
    }

    public int doGetRowCount() {
        return this.parameters.size() + 1;
    }

    public void doSetContentAt(int col, int row, Object value) {
        if (row == 0) {
            return;
        }
        if (col == 0) {
            return;
        }
        IParameterModel paramModel = this.getParamAt(row);
        if (paramModel == null) {
            return;
        }
        String storeId = MdacPreferenceStore.getId((String)this.mdac.getName(), (String)paramModel.getName());
        if (paramModel instanceof BoolParameterModel) {
            boolean v = (Boolean)value;
            if (v) {
                this.store.setValue(storeId, "TRUE");
            } else {
                this.store.setValue(storeId, "FALSE");
            }
        } else if (paramModel instanceof EnumParameterModel) {
            String val = ((EnumParameterModel)paramModel).getValue(value.toString());
            this.store.setValue(storeId, val);
        } else {
            this.store.setValue(storeId, value.toString());
        }
        this.table.redraw();
    }

    public int getInitialColumnWidth(int column) {
        double firstColumnWeight = 0.35;
        int colCount = 2;
        int availableWidth = this.table.getClientArea().width - 18;
        if (column == 0) {
            return (int)((double)availableWidth * 0.35);
        }
        return (int)((double)availableWidth * 0.65) / (colCount - 1);
    }

    public int getInitialRowHeight(int row) {
        return row == 0 ? 22 : 18;
    }

    public int getFixedHeaderColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 0;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public boolean isColumnResizable(int col) {
        return true;
    }

    public void setColumnWidth(int col, int value) {
        super.setColumnWidth(col, value);
    }

    public boolean isRowResizable(int row) {
        return false;
    }

    public int getColumnWidth(int col) {
        return super.getColumnWidth(col);
    }

    protected void initializeRenderers() {
        this.headerRenderer = new FixedCellRenderer(1);
        this.headerRenderer.setForeground(Display.getCurrent().getSystemColor(2));
        this.headerRenderer.setBackground(Display.getCurrent().getSystemColor(22));
        this.headerRenderer.setAlignment(55);
        this.textRenderer = new TextCellRenderer(16);
        this.textRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.textRenderer.setAlignment(55);
        this.passwordRenderer = new TextCellRenderer(16);
        this.passwordRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.passwordRenderer.setAlignment(55);
        this.labelRenderer = new TextCellRenderer(16);
        this.labelRenderer.setAlignment(52);
        this.labelRenderer.setForeground(Display.getCurrent().getSystemColor(2));
        this.boolRenderer = new CheckableCellRenderer(16);
        this.boolRenderer.setAlignment(55);
        this.boolRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.objectRenderer = new TextCellRenderer(16);
        this.objectRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.objectRenderer.setAlignment(55);
    }

    protected void initializeEditors() {
        this.boolEditor = new KTableCellEditorCheckbox();
        this.textEditor = new TextCellEditor();
        this.passwordEditor = new PasswordCellEditor();
        this.fileEditor = new FileCellEditor();
        this.directoryEditor = new DirectoryCellEditor();
    }

    public IParameterModel getParamAt(int row) {
        if (row > 0) {
            return (IParameterModel)this.parameters.get(row - 1);
        }
        return null;
    }
}

