/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IParameterEditionModel;
import com.modeliosoft.modelio.api.mdac.IParameterGroupModel;
import com.modeliosoft.modelio.api.mdac.IParameterModel;
import com.modeliosoft.modelio.api.module.IMdacConfiguration;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules.MdacPreferenceStore;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

/*
 * Exception performing whole class analysis ignored.
 */
public class MdacPreferenceStore
extends EventManager
implements IPersistentPreferenceStore {
    private boolean dirty = false;
    private static final String SEPARATOR = ";;;";
    private Collection<IMdac> mdacs;
    private Map<String, String> properties;
    private Map<String, String> defaultProperties = new HashMap();

    public static String getId(String moduleName, String paramName) {
        return String.valueOf(moduleName) + ";;;" + paramName;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.addListenerObject((Object)listener);
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name) || this.defaultProperties.containsKey(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] finalListeners = this.getListeners();
        if (!(finalListeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < finalListeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)finalListeners[i];
                SafeRunnable.run((ISafeRunnable)new SendPropertyChangeEventSafeRunnable(JFaceResources.getString((String)"PreferenceStore.changeError"), l, pe));
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(this.properties, name);
    }

    private boolean getBoolean(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public boolean getDefaultBoolean(String name) {
        return this.getBoolean(this.defaultProperties, name);
    }

    public double getDefaultDouble(String name) {
        return this.getDouble(this.defaultProperties, name);
    }

    public float getDefaultFloat(String name) {
        return this.getFloat(this.defaultProperties, name);
    }

    public int getDefaultInt(String name) {
        return this.getInt(this.defaultProperties, name);
    }

    public long getDefaultLong(String name) {
        return this.getLong(this.defaultProperties, name);
    }

    public String getDefaultString(String name) {
        return this.getString(this.defaultProperties, name);
    }

    public double getDouble(String name) {
        return this.getDouble(this.properties, name);
    }

    private double getDouble(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0.0;
        }
        double ival = 0.0;
        try {
            ival = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ival;
    }

    public float getFloat(String name) {
        return this.getFloat(this.properties, name);
    }

    private float getFloat(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0.0f;
        }
        float ival = 0.0f;
        try {
            ival = Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ival;
    }

    public int getInt(String name) {
        return this.getInt(this.properties, name);
    }

    private int getInt(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0;
        }
        int ival = 0;
        try {
            ival = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ival;
    }

    public long getLong(String name) {
        return this.getLong(this.properties, name);
    }

    private long getLong(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0L;
        }
        long ival = 0L;
        try {
            ival = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ival;
    }

    public String getString(String name) {
        return this.getString(this.properties, name);
    }

    private String getString(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean isDefault(String name) {
        return !this.properties.containsKey(name) && this.defaultProperties.containsKey(name);
    }

    public void list(PrintStream out) {
    }

    public void list(PrintWriter out) {
    }

    private void load() throws IOException {
        for (IMdac mdac : this.mdacs) {
            String mdacName = mdac.getName();
            Map params = mdac.getConfiguration().getParameters();
            for (Map.Entry entry : params.entrySet()) {
                String key = MdacPreferenceStore.getId((String)mdacName, (String)((String)entry.getKey()));
                this.properties.put(key, (String)entry.getValue());
            }
            IParameterEditionModel parametersEditionModel = mdac.getParametersEditionModel();
            if (parametersEditionModel == null) continue;
            for (IParameterGroupModel group : parametersEditionModel.getGroups()) {
                for (IParameterModel param : group.getParameters()) {
                    this.defaultProperties.put(param.getName(), param.getDefaultValue());
                }
            }
        }
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        return this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
    }

    public void putValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.removeListenerObject((Object)listener);
    }

    public void save() throws IOException {
        HashMap<String, IMdacConfiguration> configs = new HashMap<String, IMdacConfiguration>();
        for (IMdac iMdac : this.mdacs) {
            configs.put(iMdac.getName(), iMdac.getConfiguration());
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] keys = key.split(";;;");
            String mdacName = keys[0];
            String paramName = keys[1];
            ((IMdacConfiguration)configs.get(mdacName)).setParameterValue(paramName, value);
        }
    }

    public void setDefault(String name, float value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, int value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, String value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, boolean value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setToDefault(String name) {
        Object oldValue = this.properties.get(name);
        this.properties.remove(name);
        this.dirty = true;
        Object newValue = null;
        if (this.defaultProperties != null) {
            newValue = this.defaultProperties.get(name);
        }
        this.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if ((double)Math.abs(oldValue - value) < 1.0E-7) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, (Object)Float.valueOf(oldValue), (Object)Float.valueOf(value));
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, (Object)oldValue, (Object)value);
        }
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, (Object)oldValue, (Object)value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, (Object)(oldValue ? Boolean.TRUE : Boolean.FALSE), (Object)(value ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    private void setValue(Map<String, String> p, String name, float value) {
        p.put(name, Float.toString(value));
    }

    private void setValue(Map<String, String> p, String name, int value) {
        p.put(name, Integer.toString(value));
    }

    private void setValue(Map<String, String> p, String name, String value) {
        if (value != null) {
            p.put(name, value);
        } else {
            p.put(name, "");
        }
    }

    private void setValue(Map<String, String> p, String name, boolean value) {
        p.put(name, value ? "true" : "false");
    }

    public MdacPreferenceStore(Collection<IMdac> mdacs) {
        this.properties = new HashMap(this.defaultProperties);
        this.mdacs = mdacs;
        try {
            this.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDefault(String name, double value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, long value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (Math.abs(oldValue - value) < 1.0E-7) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, (Object)oldValue, (Object)value);
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, (Object)oldValue, (Object)value);
        }
    }

    private void setValue(Map<String, String> p, String name, double value) {
        p.put(name, Double.toString(value));
    }

    private void setValue(Map<String, String> p, String name, long value) {
        p.put(name, Long.toString(value));
    }
}

