/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IParameterGroupModel;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules.GroupPreferenceNode;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules.MdacPreferenceStore;
import com.modeliosoft.modelio.internal.app.impl.preferences.modules.modules.ModulePreferencePage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModulePreferenceNode
extends PreferenceNode {
    private IMdac mdac;
    private IModelingSession modelingSession = null;
    private MdacPreferenceStore store = null;
    private List<IPreferenceNode> nodes = null;
    private Image image = null;
    private ImageDescriptor dotDesc = null;

    public ModulePreferenceNode(IModelingSession modelingSession, IMdac mdac) {
        super(mdac.getName());
        this.modelingSession = modelingSession;
        this.mdac = mdac;
        this.store = new MdacPreferenceStore(modelingSession.getMdacRegistry().getStartedMdacs());
        List groups = this.mdac.getParametersEditionModel().getGroups();
        this.nodes = new ArrayList();
        for (IParameterGroupModel group : groups) {
            this.nodes.add(new GroupPreferenceNode(this.modelingSession, this.mdac, group, this.store));
        }
        this.dotDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/dot_16.png");
    }

    public String getLabelText() {
        String ret = this.mdac.getLabel();
        if (ret == null || ret.isEmpty()) {
            ret = this.mdac.getName();
        }
        return ret;
    }

    protected ImageDescriptor getImageDescriptor() {
        return this.mdac.getMdacImageDescriptor();
    }

    public void createPage() {
        ModulePreferencePage page = new ModulePreferencePage(this.mdac);
        page.setImageDescriptor(this.mdac.getMdacImageDescriptor());
        this.setPage((IPreferencePage)page);
    }

    public IPreferenceNode[] getSubNodes() {
        return this.nodes.toArray(new IPreferenceNode[this.nodes.size()]);
    }

    public Image getLabelImage() {
        ImageDescriptor imageDesc = this.mdac.getMdacImageDescriptor();
        if (this.image == null && imageDesc != null) {
            this.image = imageDesc.createImage();
        } else if (imageDesc == null) {
            this.image = this.dotDesc.createImage();
        }
        return this.image;
    }
}

