/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.projectinfo;

import com.modeliosoft.modelio.api.model.ObUtils;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ModelingSession;
import com.modeliosoft.modelio.core.app.AppInfos;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.migration.ProjectMigratorTool;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;

public class ProjectInfo {
    boolean fullInfo;

    public String getSummaryInfo(IProject project) {
        assert (project != null && project.getSession() != null);
        this.fullInfo = false;
        return new String(this.buildProjectReport(project));
    }

    public String getSummaryInfo(IProjectSpace projectSpace) {
        assert (projectSpace != null);
        this.fullInfo = false;
        return new String(this.buildProjectSpaceReport(projectSpace));
    }

    public String getInfo(IProject project) {
        assert (project != null && project.getSession() != null);
        this.fullInfo = true;
        return new String(this.buildProjectReport(project));
    }

    public String getInfo(IProjectSpace projectSpace) {
        assert (projectSpace != null);
        this.fullInfo = true;
        return new String(this.buildProjectSpaceReport(projectSpace));
    }

    private StringBuffer buildProjectReport(IProject project) {
        return this.buildReport(project.getProjectSpace(), project.getSession());
    }

    private StringBuffer buildProjectSpaceReport(IProjectSpace projectSpace) {
        try {
            IBase ofp = projectSpace.getDatabase();
            String lockOwner = ofp.getLockOwner();
            if (!lockOwner.isEmpty()) {
                return this.buildLockedBaseReport(projectSpace);
            }
            if (ProjectMigratorTool.isMigrationRequired((IBase)projectSpace.getDatabase())) {
                return this.buildMigrationReport(projectSpace);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.makeErrorInfo(projectSpace, e.getLocalizedMessage());
        }
        ModelingSession session = new ModelingSession();
        try {
            session.openProject(projectSpace.getDataDirectory(), projectSpace.getDatabase().getFile().getName(), true);
        }
        catch (IllegalStateException e) {
            return this.makeErrorInfo(projectSpace, e.getLocalizedMessage());
        }
        catch (IOException e) {
            return this.makeErrorInfo(projectSpace, e.getLocalizedMessage());
        }
        StringBuffer results = this.buildReport(projectSpace, (IModelingSession)session);
        session.close();
        return results;
    }

    private StringBuffer buildReport(IProjectSpace projectSpace, IModelingSession session) {
        int toolMMVersion;
        StringBuffer html = new StringBuffer();
        html.append("<HTML>");
        html.append("<head>");
        html.append(this.getStyleSheet());
        html.append("<title>");
        html.append("</title> </head>");
        html.append("<BODY><TABLE width=\"100%\">");
        int ofpMMVersion = toolMMVersion = AppInfos.getMetamodelVersion();
        boolean migrationNeeded = false;
        boolean migrationSupported = true;
        html.append(this.getTitleHTMLCode(Messages.getString((String)"ProjectInfo.ProjectInformation")));
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.Name"), projectSpace.getName()));
        html.append(this.makeProjectDate(projectSpace));
        html.append(this.makeMMVersion(toolMMVersion, ofpMMVersion, migrationNeeded, migrationSupported));
        if (session != null) {
            html.append(this.makeProjectAuthor(session));
            html.append(this.makeProjectDescription(session));
            if (this.fullInfo) {
                html.append(this.makeProjectModules(session));
                html.append(this.makeProjectComponents(session));
                html.append(this.makeProjectStatistics(session));
            }
        }
        return html;
    }

    private String getStyleSheet() {
        return "<style type=\"text/css\">body, table {  font-family: arial, verdana; font-size: 0.82em; color: #3E3E3E; margin: 0;} td.key {  width: 180px;}td.value {color: #3E3E3E; font-weight:bold;}td.title {background-color: #AD0000; color: white;  font-weight: bold;}</style>";
    }

    private StringBuffer buildMigrationReport(IProjectSpace projectSpace) {
        StringBuffer html = new StringBuffer();
        html.append("<HTML>");
        html.append("<head>");
        html.append(this.getStyleSheet());
        html.append("<title>");
        html.append("</title> </head>");
        html.append("<BODY><TABLE width=\"100%\">");
        IBase ofp = projectSpace.getDatabase();
        int ofpMMVersion = 0;
        int toolMMVersion = AppInfos.getMetamodelVersion();
        boolean migrationNeeded = true;
        boolean migrationSupported = false;
        try {
            ofpMMVersion = ofp.getMetamodelVersion();
            migrationNeeded = ProjectMigratorTool.isMigrationRequired((IBase)ofp);
            migrationSupported = ProjectMigratorTool.isMigrationSupported((IBase)ofp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        html.append(this.getTitleHTMLCode(Messages.getString((String)"ProjectInfo.ProjectInformation")));
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.Name"), projectSpace.getName()));
        html.append(this.makeProjectDate(projectSpace));
        html.append(this.makeMMVersion(toolMMVersion, ofpMMVersion, migrationNeeded, migrationSupported));
        return html;
    }

    private StringBuffer makeErrorInfo(IProjectSpace projectSpace, String localizedMessage) {
        StringBuffer html = new StringBuffer();
        html.append("<b><font color=\"red\">" + projectSpace.getName() + "</b></font> : ");
        html.append(localizedMessage);
        return html;
    }

    private StringBuffer makeProjectStatistics(IModelingSession session) {
        StringBuffer html = new StringBuffer();
        html.append(this.getTitleHTMLCode(Messages.getString((String)"ProjectInfo.ProjectStatistics")));
        List p = session.getModel().findByClass(IPackage.class);
        List c = session.getModel().findByClass(IGeneralClass.class);
        session.getModel().findByClass(ITaggedValue.class);
        List d = session.getModel().findByClass(IAbstractDiagram.class);
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.nbpackages"), String.valueOf(p.size())));
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.nbclasses"), String.valueOf(c.size())));
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.nbdiagrams"), String.valueOf(d.size())));
        return html;
    }

    private StringBuffer makeProjectComponents(IModelingSession session) {
        StringBuffer html = new StringBuffer();
        html.append(this.getTitleHTMLCode(Messages.getString((String)"ProjectInfo.ModelComponents")));
        IPackage root = session.getModel().getProject().getModel();
        int nbRamcs = 0;
        for (IModelTree element : root.getOwnedElement(IComponent.class)) {
            IElementStatus status = element.getElementStatus();
            if (!status.isRamcObject()) continue;
            IComponent component = (IComponent)element;
            String version = "?";
            ObList artifacts = component.getOwnedElement(IArtifact.class);
            for (IArtifact e : artifacts) {
                String v;
                if (!e.isStereotyped("ModelComponentArchive") || (v = ObUtils.getTagValue((IModelElement)e, (String)"ModelComponentVersion")) == null || v.isEmpty()) continue;
                version = v;
            }
            html.append(this.getPropertyHTMLCode(component.getName(), version));
            ++nbRamcs;
        }
        if (nbRamcs == 0) {
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.none")));
        }
        return html;
    }

    private StringBuffer makeProjectModules(IModelingSession session) {
        StringBuffer html = new StringBuffer();
        html.append(this.getTitleHTMLCode(Messages.getString((String)"ProjectInfo.Modules")));
        int nbModules = 0;
        for (IModule module : session.getModel().getProject().getInstalled()) {
            if (module.getName().equals("LocalModule")) continue;
            html.append(this.getPropertyHTMLCode(module.getName(), module.getVersion()));
            ++nbModules;
        }
        if (nbModules == 0) {
            html.append(this.getPropertyHTMLCode("none"));
        }
        return html;
    }

    private StringBuffer makeMMVersion(int toolMMversion, int projectMMVersion, boolean migrationRequired, boolean migrationSupported) {
        StringBuffer html = new StringBuffer();
        if (migrationRequired) {
            String version = "<font color=\"red\">" + String.valueOf(projectMMVersion) + "</font>";
            String diagnostic = migrationSupported ? "<font color=\"green\">" + Messages.getMessage((String)"ProjectInfo.MigrationDiagnosticOK", (String[])new String[]{String.valueOf(toolMMversion)}) + "</font>" : "<font color=\"red\">" + Messages.getMessage((String)"ProjectInfo.MigrationDiagnosticNOK", (String[])new String[]{String.valueOf(toolMMversion)}) + "</font>";
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.MetamodelVersion"), version));
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.MigrationConditions"), diagnostic));
        } else {
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.MetamodelVersion"), String.valueOf(projectMMVersion)));
        }
        return html;
    }

    private StringBuffer makeProjectDate(IProjectSpace projectSpace) {
        StringBuffer html = new StringBuffer();
        Date ofpDate = new Date(projectSpace.getDatabase().getFile().lastModified());
        String dateStr = DateFormat.getInstance().format(ofpDate);
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.LastModificationDate"), dateStr));
        return html;
    }

    private StringBuffer makeProjectDescription(IModelingSession session) {
        StringBuffer html = new StringBuffer();
        html.append(this.getTitleHTMLCode("Description"));
        IPackage root = session.getModel().getProject().getModel();
        String desc = root.getNoteContent("description");
        if (desc != null && !desc.isEmpty()) {
            html.append(this.getPropertyHTMLCode(desc));
        } else {
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.NoAvailableDescription")));
        }
        return html;
    }

    private StringBuffer getPropertyHTMLCode(String key, String value) {
        StringBuffer html = new StringBuffer();
        html.append("<tr>");
        html.append("<td class=\"key\">");
        html.append(key);
        html.append("</td>");
        html.append("<td class=\"value\">");
        html.append(value);
        html.append("</td></tr>");
        return html;
    }

    private StringBuffer getPropertyHTMLCode(String value) {
        StringBuffer html = new StringBuffer();
        html.append("<tr>");
        html.append("<td colspan=\"2\" class=\"value\">");
        html.append(value);
        html.append("</td></tr>");
        return html;
    }

    private StringBuffer getTitleHTMLCode(String title) {
        StringBuffer html = new StringBuffer();
        html.append("<tr>");
        html.append("<td colspan=\"2\" class=\"title\">");
        html.append(title);
        html.append("</td></tr>");
        return html;
    }

    private StringBuffer buildLockedBaseReport(IProjectSpace projectSpace) {
        String lockOwner;
        StringBuffer html = new StringBuffer();
        html.append("<HTML>");
        html.append("<head>");
        html.append(this.getStyleSheet());
        html.append("<title>");
        html.append("</title> </head>");
        html.append("<BODY><TABLE width=\"100%\">");
        IBase ofp = projectSpace.getDatabase();
        try {
            lockOwner = ofp.getLockOwner();
        }
        catch (IOException e) {
            e.printStackTrace();
            lockOwner = "?";
        }
        html.append(this.getTitleHTMLCode(Messages.getString((String)"ProjectInfo.ProjectInformation")));
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.Name"), projectSpace.getName()));
        html.append(this.makeProjectDate(projectSpace));
        html.append(this.makeLockStatus(lockOwner));
        return html;
    }

    private StringBuffer makeLockStatus(String lockOwner) {
        StringBuffer html = new StringBuffer();
        String lockOwnerValue = "<font color=\"red\">" + lockOwner + "</font>";
        html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.LockedBy"), lockOwnerValue));
        return html;
    }

    private StringBuffer makeProjectAuthor(IModelingSession session) {
        StringBuffer html = new StringBuffer();
        String author = session.getConfigProperties().getProperty("Modelio", "Project.Author");
        if (author != null && !author.isEmpty()) {
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.Author"), author));
        } else {
            html.append(this.getPropertyHTMLCode(Messages.getString((String)"ProjectInfo.Author"), Messages.getString((String)"ProjectInfo.NoAvailableAuthor")));
        }
        return html;
    }
}

