/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.search;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.internal.app.impl.search.SearchComboControl;
import com.modeliosoft.modelio.internal.app.impl.search.SearchResults;
import com.modeliosoft.modelio.internal.app.impl.search.Searcher;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.App;
import java.util.List;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class SearchComboControl
extends WorkbenchWindowControlContribution {
    private SCWSessionListener sessionListener;
    private Combo searchCombo;

    protected Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 1;
        comp.setLayout((Layout)gridLayout);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString((String)"Search"));
        label.setForeground(UIColor.EDITOR_ROTEXT_FG);
        GridData gd_label = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)gd_label);
        this.searchCombo = new Combo(comp, 772);
        this.searchCombo.setToolTipText(Messages.getString((String)"SearchTooltip"));
        this.searchCombo.addSelectionListener((SelectionListener)new SCWSelectionListener(this, this));
        this.searchCombo.setEnabled(false);
        GridData gd = new GridData(768);
        gd.minimumWidth = 120;
        gd.widthHint = 120;
        this.searchCombo.setLayoutData((Object)gd);
        this.searchCombo.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchCombo.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new SCWSessionListener(this, this);
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this.sessionListener);
        return comp;
    }

    private void runSearch(String expression) {
        IModelingSession session = App.getInstance().getOpenedProject().getSession();
        Searcher searcher = new Searcher(session, expression);
        List found = searcher.search();
        switch (found.size()) {
            case 0: {
                this.runExtendedSearch(expression);
                break;
            }
            case 1: {
                O.getDefault().getNavigateService().fireNavigate((IElement)found.get(0));
                break;
            }
            default: {
                SearchResults dlg = new SearchResults(null, searcher, found);
                dlg.open();
            }
        }
    }

    public void dispose() {
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this.sessionListener);
        super.dispose();
    }

    private void runExtendedSearch(String expression) {
        IModelingSession session = App.getInstance().getOpenedProject().getSession();
        if (!expression.endsWith(".*")) {
            expression = String.valueOf(expression) + ".*";
        }
        Searcher searcher = new Searcher(session, expression);
        List found = searcher.search();
        switch (found.size()) {
            case 0: {
                SearchResults dlg = new SearchResults(null, searcher, found);
                dlg.open();
                break;
            }
            case 1: {
                O.getDefault().getNavigateService().fireNavigate((IElement)found.get(0));
                break;
            }
            default: {
                SearchResults dlg2 = new SearchResults(null, searcher, found);
                dlg2.open();
            }
        }
    }

    public Combo getSearchCombo() {
        return this.searchCombo;
    }

    public SCWSessionListener getSessionListener() {
        return this.sessionListener;
    }

    static /* synthetic */ Combo access$0(SearchComboControl searchComboControl) {
        return searchComboControl.searchCombo;
    }

    static /* synthetic */ void access$1(SearchComboControl searchComboControl, String string) {
        searchComboControl.runSearch(string);
    }
}

