/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.search;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.core.IModelingSession;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Searcher {
    private String expression = null;
    private IModelingSession session = null;

    public Searcher(IModelingSession session, String expression) {
        this.session = session;
        this.expression = expression;
    }

    public List<IElement> search() {
        List rawResults = this.session.getModel().findByClass(INameSpace.class);
        Vector<IElement> filteredResults = new Vector<IElement>();
        try {
            Pattern p = Pattern.compile(this.expression, 2);
            for (IElement e : rawResults) {
                IModelElement me;
                if (!(e instanceof IModelElement) || !p.matcher((me = (IModelElement)e).getName()).matches()) continue;
                filteredResults.add(e);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return filteredResults;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public static boolean isValidExpression(String expression) {
        try {
            Pattern.compile(expression, 2);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public String getExpression() {
        return this.expression;
    }
}

