/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.control;

import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.App;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

public class CloseProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        App app = App.getInstance();
        IProject currentProject = app.getOpenedProject();
        O.getDefault().getPickingProviderService().abortPicking();
        if (!currentProject.isDirty()) {
            app.closeProject();
        } else {
            String[] tab = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getMessage((String)"SaveBeforeCloseTitle", (String[])new String[0]), null, Messages.getMessage((String)"SaveBeforeCloseQuestion", (String[])new String[]{currentProject.getName()}), 3, tab, 0);
            int choice = dialog.open();
            if (choice == -1 || tab[choice] == IDialogConstants.CANCEL_LABEL) {
                return null;
            }
            if (tab[choice] == IDialogConstants.YES_LABEL) {
                app.saveProject();
            }
            app.closeProject();
        }
        return null;
    }

    public boolean isEnabled() {
        return App.getInstance().getOpenedProject() != null;
    }

    public boolean isHandled() {
        return true;
    }
}

