/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.control;

import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.App;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        App app = App.getInstance();
        IWorkspace workspace = app.getWorkspace();
        List projects = workspace.getSelectedProjectSpaces();
        for (IProjectSpace project : projects) {
            if (!project.isOpened()) continue;
            MessageDialog.openError(null, (String)Messages.getString((String)"ForbiddenProjectDeletion"), (String)Messages.getString((String)"CannotDeleteOpenProject"));
            return null;
        }
        String[] tab = new String[]{Messages.getString((String)"DeleteProject"), Messages.getString((String)"CancelProjectDeletion")};
        StringBuffer projectNames = new StringBuffer();
        for (IProjectSpace project : projects) {
            projectNames.append("   - ");
            projectNames.append(project.getName());
            projectNames.append("\n");
        }
        MessageDialog dialog = new MessageDialog(null, Messages.getString((String)"ConfirmProjectDeletion"), null, Messages.getMessage((String)"ConfirmProjectDeletionMessage", (String[])new String[]{projectNames.toString()}), 3, tab, 0);
        int choice = dialog.open();
        if (choice == 0) {
            StringBuffer lockedProjectNames = new StringBuffer();
            for (IProjectSpace project : projects) {
                try {
                    IBase ofp = project.getDatabase();
                    if (ofp.getLockOwner().equals("")) {
                        workspace.deleteProjectSpace(project);
                        continue;
                    }
                    lockedProjectNames.append("   - ");
                    lockedProjectNames.append(project.getName());
                    lockedProjectNames.append("\n");
                }
                catch (IOException e) {
                    lockedProjectNames.append("   - ");
                    lockedProjectNames.append(project.getName());
                    lockedProjectNames.append("   : ");
                    lockedProjectNames.append(e.getLocalizedMessage());
                    lockedProjectNames.append("\n");
                }
            }
            workspace.refreshProjects();
            if (lockedProjectNames.length() > 0) {
                String[] lockedTab = new String[]{Messages.getString((String)"DeleteProjectCommand.CannotDeleteLockedProjectOk")};
                MessageDialog lockedDialog = new MessageDialog(null, Messages.getString((String)"DeleteProjectCommand.CannotDeleteLockedProjectTitle"), null, Messages.getMessage((String)"DeleteProjectCommand.CannotDeleteLockedProjectMessage", (String[])new String[]{lockedProjectNames.toString()}), 2, lockedTab, 0);
                lockedDialog.open();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkspace workspace = App.getInstance().getWorkspace();
        List projectSpaces = workspace.getSelectedProjectSpaces();
        int selectedNumber = projectSpaces.size();
        for (IProjectSpace projectSpace : projectSpaces) {
            if (!projectSpace.isOpened()) continue;
            return false;
        }
        return selectedNumber > 0;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

