/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.control;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.App;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        App app = App.getInstance();
        IWorkspace workspace = app.getWorkspace();
        IProjectSpace projectSpace = workspace.getSelectedProjectSpace();
        if (projectSpace != null) {
            try {
                app.openProject(projectSpace);
                app.saveProject();
                IModelingSession session = app.getOpenedProject().getSession();
                O.getDefault().getNavigateService().fireNavigate((IElement)session.getModel().getProject().getModel());
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getMessage((String)"OpenFailedTitle", (String[])new String[]{projectSpace.getName()}), (String)Messages.getMessage((String)"OpenFailedMsg", (String[])new String[]{projectSpace.getName(), e.toString()}));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getMessage((String)"OpenFailedTitle", (String[])new String[]{projectSpace.getName()}), (String)Messages.getMessage((String)"OpenFailedMsg", (String[])new String[]{projectSpace.getName(), e.getLocalizedMessage()}));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && App.getInstance().getOpenedProject() == null;
    }

    public boolean isHandled() {
        return true;
    }
}

