/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.control;

import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import com.modeliosoft.modelio.internal.app.services.App;
import com.modeliosoft.modelio.internal.app.services.ui.ProjectNameValidator;
import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

public class RenameProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkspace workspace = App.getInstance().getWorkspace();
        IProjectSpace projectSpace = workspace.getSelectedProjectSpace();
        if (projectSpace == null) {
            return null;
        }
        String currentName = projectSpace.getName();
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"RenameProject.Title"), Messages.getString((String)"RenameProject.Message"), currentName, (IInputValidator)new ProjectNameValidator(workspace));
        if (dialog.open() == 0) {
            String newName = dialog.getValue();
            File currentOfpx = projectSpace.getDatabase().getFile();
            File newOfpx = new File(projectSpace.getDataDirectory(), String.valueOf(newName) + ".ofpx");
            currentOfpx.renameTo(newOfpx);
            File currentDir = projectSpace.getProjectDirectory();
            File newDir = new File(workspace.getDirectory(), newName);
            boolean renamed = currentDir.renameTo(newDir);
            if (!renamed) {
                System.gc();
                Thread.yield();
                renamed = currentDir.renameTo(newDir);
            }
            if (renamed) {
                workspace.refreshProjects();
            } else {
                newOfpx.renameTo(currentOfpx);
                String[] tab = new String[]{"Ok"};
                MessageDialog lockedDialog = new MessageDialog(null, Messages.getString((String)"RenameProject.CannotRenameLockedFileTitle"), null, Messages.getMessage((String)"RenameProject.CannotRenameLockedFileMessage", (String[])new String[]{currentName}), 4, tab, 0);
                lockedDialog.open();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return App.getInstance().getOpenedProject() == null;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

