/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.model;

import com.modeliosoft.modelio.core.ExmlRepository;
import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.BaseFinder;
import java.io.File;
import java.util.Collection;

public abstract class AbstractProjectSpace
implements IProjectSpace,
Comparable<IProjectSpace> {
    protected IBase database;
    protected String name;
    protected boolean opened;
    protected File projectDirectory;

    public void close() {
        this.opened = false;
    }

    @Override
    public int compareTo(IProjectSpace o) {
        return this.name.compareTo(o.getName());
    }

    public void open() {
        this.opened = true;
    }

    public void delete(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                this.delete(subFile);
                ++n2;
            }
            file.delete();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isOpened() {
        return this.opened;
    }

    private OfpFile findOfpFile(File directory) {
        Collection projectFiles = BaseFinder.getOfpx((File)directory);
        if (projectFiles != null && !projectFiles.isEmpty()) {
            return new OfpFile((File)projectFiles.iterator().next());
        }
        return null;
    }

    protected IBase findBase(File directory) {
        OfpFile ret = this.findOfpFile(directory);
        if (ret != null) {
            return ret;
        }
        File reposPath = BaseFinder.getExmlRepository((File)directory);
        if (reposPath != null) {
            return new ExmlRepository(reposPath);
        }
        return null;
    }
}

