/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.model;

import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.internal.app.InvalidProjectSpaceException;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.AbstractProjectSpace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ProjectSpace
extends AbstractProjectSpace {
    private String description = null;

    public ProjectSpace(String name, File projectLocation) throws InvalidProjectSpaceException {
        this.name = name;
        this.projectDirectory = projectLocation;
        this.database = this.findBase(this.projectDirectory);
    }

    public IBase getDatabase() {
        if (this.database == null) {
            this.database = this.findBase(this.projectDirectory);
        }
        return this.database;
    }

    public void deleteContent() {
        this.delete(this.getDataDirectory());
    }

    public File getDataDirectory() {
        return this.projectDirectory;
    }

    public String getDescription() {
        if (this.description == null) {
            String readDescription;
            block20: {
                readDescription = null;
                File configFile = new File(this.getDataDirectory(), ".config/project.prefs");
                Properties configProperties = new Properties();
                if (configFile.isFile()) {
                    FileInputStream inConfigStream = null;
                    try {
                        inConfigStream = new FileInputStream(configFile);
                        configProperties.load(inConfigStream);
                        ((InputStream)inConfigStream).close();
                        readDescription = configProperties.getProperty("Modelio.Project.Description");
                    }
                    catch (FileNotFoundException e) {
                        inConfigStream = null;
                        configProperties = null;
                        LOG.error((String)"org.modelio.app.internal", (Throwable)e);
                        try {
                            if (inConfigStream != null) {
                                ((InputStream)inConfigStream).close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            LOG.error((String)"org.modelio.app.internal", (Throwable)e2);
                        }
                        break block20;
                    }
                    catch (IOException e) {
                        try {
                            inConfigStream = null;
                            configProperties = null;
                            LOG.error((String)"org.modelio.app.internal", (Throwable)e);
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (inConfigStream != null) {
                                    ((InputStream)inConfigStream).close();
                                }
                            }
                            catch (IOException e3) {
                                LOG.error((String)"org.modelio.app.internal", (Throwable)e3);
                            }
                        }
                    }
                    try {
                        if (inConfigStream != null) {
                            ((InputStream)inConfigStream).close();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((String)"org.modelio.app.internal", (Throwable)e);
                    }
                }
            }
            this.description = readDescription != null ? readDescription : "";
        }
        return this.description;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }
}

