/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.model;

import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.internal.app.InvalidProjectSpaceException;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.AbstractProjectSpace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class RedirectedProjectSpace
extends AbstractProjectSpace {
    private File redirectory;
    private String description = null;

    public RedirectedProjectSpace(String name, File projectDirectory) throws InvalidProjectSpaceException {
        this.name = name;
        this.projectDirectory = projectDirectory;
        File redir = new File(projectDirectory, ".redir");
        String redirectedPath = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(redir));
            redirectedPath = reader.readLine();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InvalidProjectSpaceException();
        }
        if (redirectedPath == null) {
            throw new InvalidProjectSpaceException();
        }
        File redirectionDir = new File(redirectedPath);
        if (!(redirectionDir.exists() && redirectionDir.isDirectory() && redirectionDir.canWrite())) {
            throw new InvalidProjectSpaceException();
        }
        this.redirectory = redirectionDir;
        this.database = this.findBase(this.redirectory);
    }

    public void deleteContent() {
        this.deleteDataContent(this.getDataDirectory());
        this.delete(this.getProjectDirectory());
    }

    private void deleteDataContent(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                this.delete(files[i]);
                ++i;
            }
        }
    }

    public File getDataDirectory() {
        return this.redirectory;
    }

    public String getDescription() {
        if (this.description == null) {
            String readDescription;
            block20: {
                readDescription = null;
                File configFile = new File(this.getDataDirectory(), ".config/project.prefs");
                Properties configProperties = new Properties();
                if (configFile.isFile()) {
                    FileInputStream inConfigStream = null;
                    try {
                        inConfigStream = new FileInputStream(configFile);
                        configProperties.load(inConfigStream);
                        ((InputStream)inConfigStream).close();
                        readDescription = configProperties.getProperty("Modelio.Project.Description");
                    }
                    catch (FileNotFoundException e) {
                        inConfigStream = null;
                        configProperties = null;
                        e.printStackTrace();
                        try {
                            if (inConfigStream != null) {
                                ((InputStream)inConfigStream).close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block20;
                    }
                    catch (IOException e) {
                        try {
                            inConfigStream = null;
                            configProperties = null;
                            e.printStackTrace();
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (inConfigStream != null) {
                                    ((InputStream)inConfigStream).close();
                                }
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                    try {
                        if (inConfigStream != null) {
                            ((InputStream)inConfigStream).close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.description = readDescription != null ? readDescription : "";
        }
        return this.description;
    }

    public IBase getDatabase() {
        if (this.database == null) {
            this.database = this.findBase(this.redirectory);
        }
        return this.database;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }
}

