/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.model;

import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.InvalidProjectSpaceException;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.BaseFinder;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.ProjectSpace;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.RedirectedProjectSpace;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.Workspace;
import com.modeliosoft.modelio.internal.app.impl.workspace.view.WorkspaceNavigatorView;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class Workspace
extends PlatformObject
implements IWorkspace {
    protected File directory;
    protected SortedSet<IProjectSpace> projects;
    private static final String WORKSPACE_VIEW_ID = "com.modeliosoft.modelio.app.WorkspaceNavigatorViewID";

    public Workspace(File directory) {
        this.directory = directory;
        try {
            this.directory = this.directory.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.projects = new TreeSet();
        O.getDefault().setWorkspacePath(directory);
        this.refreshProjects();
    }

    public boolean changeDirectory(File dir) {
        if (dir.exists() && dir.isDirectory() && dir.canWrite()) {
            this.directory = dir;
            try {
                this.directory = this.directory.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            O.getDefault().setWorkspacePath(dir);
            this.projects.clear();
            this.refreshProjects();
            WorkspaceNavigatorView view = this.getNavigatorView();
            if (view != null) {
                view.setWorkspace((IWorkspace)this);
            }
        }
        return false;
    }

    public void closeProjectSpace(IProjectSpace projectSpace) {
        projectSpace.close();
        this.updateNavigatorView();
    }

    public IProjectSpace createProjectSpace(String projectName) throws InvalidProjectSpaceException {
        File projectDirectory = new File(this.directory, projectName);
        projectDirectory.mkdirs();
        ProjectSpace newProjectSpace = null;
        newProjectSpace = new ProjectSpace(projectName, projectDirectory);
        this.projects.add(newProjectSpace);
        this.updateNavigatorView();
        return newProjectSpace;
    }

    public IProjectSpace createRedirectedProjectSpace(String projectName, File redirection) throws InvalidProjectSpaceException {
        File projectDirectory = new File(this.directory, projectName);
        projectDirectory.mkdirs();
        File redir = new File(projectDirectory, ".redir");
        FileOutputStream buffer = null;
        try {
            redirection.mkdirs();
            redir.createNewFile();
            buffer = new FileOutputStream(redir);
            buffer.write(redirection.getAbsolutePath().getBytes());
            buffer.close();
        }
        catch (IOException e) {
            throw new InvalidProjectSpaceException();
        }
        RedirectedProjectSpace newProjectSpace = new RedirectedProjectSpace(projectName, projectDirectory);
        this.projects.add(newProjectSpace);
        return newProjectSpace;
    }

    public void deleteProjectSpace(IProjectSpace projectSpace) {
        projectSpace.deleteContent();
        File directoryToDelete = new File(this.getDirectory(), projectSpace.getName());
        directoryToDelete.delete();
        this.updateNavigatorView();
    }

    public File getDirectory() {
        return this.directory;
    }

    public IProjectSpace getProjectSpace(String projectName) {
        for (IProjectSpace p : this.projects) {
            if (p.getName().compareToIgnoreCase(projectName) != 0) continue;
            return p;
        }
        return null;
    }

    public SortedSet<IProjectSpace> getProjects() {
        return this.projects;
    }

    public IProjectSpace getSelectedProjectSpace() {
        TreeItem[] selection;
        WorkspaceNavigatorView view = this.getNavigatorView();
        if (view == null) {
            return null;
        }
        CommonViewer viewer = view.getCommonViewer();
        if (viewer == null) {
            return null;
        }
        Tree tree = viewer.getTree();
        if (tree == null) {
            return null;
        }
        TreeItem[] treeItemArray = selection = tree.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof IProjectSpace) {
                return (IProjectSpace)data;
            }
            ++n2;
        }
        return null;
    }

    public List<IProjectSpace> getSelectedProjectSpaces() {
        TreeItem[] selection;
        ArrayList<IProjectSpace> selectedProjects = new ArrayList<IProjectSpace>();
        WorkspaceNavigatorView view = this.getNavigatorView();
        if (view == null) {
            return selectedProjects;
        }
        CommonViewer viewer = view.getCommonViewer();
        if (viewer == null) {
            return selectedProjects;
        }
        Tree tree = viewer.getTree();
        if (tree == null) {
            return selectedProjects;
        }
        TreeItem[] treeItemArray = selection = tree.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof IProjectSpace) {
                selectedProjects.add((IProjectSpace)data);
            }
            ++n2;
        }
        return selectedProjects;
    }

    public void openProjectSpace(IProjectSpace projectSpace) throws IOException {
        try {
            projectSpace.open();
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        this.updateNavigatorView();
    }

    public void refreshProjects() {
        File workspaceFile = this.getDirectory();
        File[] projectDirectories = workspaceFile.listFiles();
        if (projectDirectories == null) {
            return;
        }
        int i = 0;
        while (i < projectDirectories.length) {
            File candidate = projectDirectories[i];
            if (this.getProjectSpace(candidate.getName()) == null) {
                try {
                    if (this.isRedirectedProjectSpace(candidate)) {
                        this.projects.add(new RedirectedProjectSpace(candidate.getName(), candidate));
                    } else if (this.isDirectProjectSpace(candidate)) {
                        this.projects.add(new ProjectSpace(candidate.getName(), candidate));
                    }
                }
                catch (InvalidProjectSpaceException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        TreeSet<IProjectSpace> validProjects = new TreeSet<IProjectSpace>();
        for (IProjectSpace p : this.projects) {
            if (!p.getDataDirectory().exists() || p.getDatabase() == null || !p.getDatabase().getFile().exists()) continue;
            validProjects.add(p);
        }
        this.projects = validProjects;
        this.updateNavigatorView();
    }

    private WorkspaceNavigatorView getNavigatorView() {
        IViewReference[] viewReferences;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            if (WORKSPACE_VIEW_ID.equals(viewReference.getId())) {
                return (WorkspaceNavigatorView)viewReference.getView(false);
            }
            ++n2;
        }
        return null;
    }

    private boolean isDirectProjectSpace(File file) {
        return BaseFinder.containsAnOfpx((File)file) || BaseFinder.containsAnExmlRepository((File)file);
    }

    private boolean isRedirectedProjectSpace(File file) {
        1 filter = new /* Unavailable Anonymous Inner Class!! */;
        File[] projectFiles = file.listFiles((FileFilter)filter);
        if (projectFiles != null) {
            return projectFiles.length > 0;
        }
        return false;
    }

    void updateNavigatorView() {
        WorkspaceNavigatorView view = this.getNavigatorView();
        if (view != null) {
            view.getCommonViewer().refresh();
        } else {
            this.postPendingUpdate();
        }
    }

    private void postPendingUpdate() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        activePage.addPartListener((IPartListener2)new /* Unavailable Anonymous Inner Class!! */);
    }
}

