/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.impl.workspace.view;

import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.ProjectSpace;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.RedirectedProjectSpace;
import java.io.File;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorLabelProvider
implements ILabelProvider {
    private Image openedProjectImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/navOpenedProject_16.png").createImage();
    private Image closedProjectImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/navClosedProject_16.png").createImage();
    private Image folderImage = null;
    private Image fileImage = null;
    private Image openedRedirProjectImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/navOpenedRedirProject_16.png").createImage();
    private Image closedRedirProjectImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/navClosedRedirProject_16.png").createImage();

    public Image getImage(Object element) {
        if (element instanceof ProjectSpace) {
            IProjectSpace projectSpace = (IProjectSpace)element;
            if (projectSpace.isOpened()) {
                return this.openedProjectImage;
            }
            return this.closedProjectImage;
        }
        if (element instanceof RedirectedProjectSpace) {
            IProjectSpace projectSpace = (IProjectSpace)element;
            if (projectSpace.isOpened()) {
                return this.openedRedirProjectImage;
            }
            return this.closedRedirProjectImage;
        }
        if (element instanceof File) {
            File f = (File)element;
            return f.isDirectory() ? this.folderImage : this.fileImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IProjectSpace) {
            IProjectSpace projectSpace = (IProjectSpace)element;
            return projectSpace.getName();
        }
        if (element instanceof File) {
            return ((File)element).getName();
        }
        return new String(element.getClass().toString());
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.openedProjectImage.dispose();
        this.openedProjectImage = null;
        this.closedProjectImage.dispose();
        this.closedProjectImage = null;
        this.openedRedirProjectImage.dispose();
        this.openedRedirProjectImage = null;
        this.closedRedirProjectImage.dispose();
        this.closedRedirProjectImage = null;
        this.folderImage.dispose();
        this.folderImage = null;
        this.fileImage.dispose();
        this.fileImage = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public NavigatorLabelProvider() {
        this.folderImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/navFolder_16.png").createImage();
        this.fileImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/navFile_16.png").createImage();
    }
}

