/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.services;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.ProjectException;
import com.modeliosoft.modelio.internal.app.impl.editors.history.EditorLocationHistory;
import com.modeliosoft.modelio.internal.app.impl.handlers.HandlersActivationManager;
import com.modeliosoft.modelio.internal.app.impl.model.Project;
import com.modeliosoft.modelio.internal.app.impl.workspace.model.Workspace;
import com.modeliosoft.modelio.internal.app.impl.workspace.view.WorkspaceNavigatorView;
import com.modeliosoft.modelio.internal.app.services.App;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class App
implements ISessionListener {
    private static String appTitle = "Modelio";
    private static final App INSTANCE = new App();
    private final IWorkspace workspace;
    private HandlersActivationManager handlersActivationManager = null;
    private EditorLocationHistory editorLocationHistory = null;
    private IProject openedProject = null;
    protected IWorkbenchListener saveBeforeQuitListener = new QuitListener();

    public static App getInstance() {
        return INSTANCE;
    }

    public static void setApplicationTitle(String title) {
        appTitle = title;
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(appTitle);
        }
    }

    private App() {
        File configFile;
        PlatformUI.getWorkbench().addWorkbenchListener(this.saveBeforeQuitListener);
        InstanceScope s = new InstanceScope();
        String dir = s.getNode("org.modelio.app.internal").get("workspace.dir", null);
        File wkDir = null;
        if (dir == null || dir.isEmpty()) {
            File userHome = new File(System.getProperty("user.home"));
            wkDir = new File(userHome, "modelio/workspace");
            if (!wkDir.exists()) {
                wkDir.mkdirs();
            }
        } else {
            wkDir = new File(dir);
        }
        if (!(configFile = new File(wkDir, ".config")).exists()) {
            configFile.mkdirs();
        }
        try {
            wkDir = wkDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.workspace = new Workspace(wkDir);
        this.handlersActivationManager = new HandlersActivationManager();
        this.editorLocationHistory = new EditorLocationHistory();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(appTitle);
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
    }

    public void closeProject() {
        assert (this.openedProject != null);
        this.openedProject.close();
        this.openedProject.getProjectSpace().close();
        this.openedProject = null;
        this.switchToWorkspacePerspective();
        WorkspaceNavigatorView.refresh();
    }

    public IProject getOpenedProject() {
        return this.openedProject;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public void openProject(IProjectSpace projectSpace) throws IOException, ProjectException, InterruptedException {
        assert (this.openedProject == null);
        String projectName = projectSpace.getName();
        String user = "";
        String pass = "";
        Project project = new Project(projectName, "", "", projectSpace);
        this.openedProject = project;
        projectSpace.open();
        WorkspaceNavigatorView.refresh();
        this.switchToProjectPerspective();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(false, false, (IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InvocationTargetException e) {
            this.switchToWorkspacePerspective();
            this.openedProject = null;
            projectSpace.close();
            WorkspaceNavigatorView.refresh();
            Throwable cause = e.getCause();
            if (cause instanceof ProjectException) {
                throw (ProjectException)cause;
            }
            throw new ProjectException(cause);
        }
    }

    public void saveProject() {
        assert (this.openedProject != null);
        this.openedProject.save();
        this.handlersActivationManager.updateHandlersActivation();
        WorkspaceNavigatorView.refresh();
    }

    public void sessionClosed(IModelingSession modelingSession) {
        this.editorLocationHistory.stop();
        this.handlersActivationManager.stop(modelingSession);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(appTitle);
    }

    public void sessionOpened(IModelingSession modelingSession) {
        String title = String.valueOf(modelingSession.getProjectSpacePath().getName()) + " - " + appTitle;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(title);
        this.handlersActivationManager.start(modelingSession);
        this.editorLocationHistory.start();
    }

    private void switchToWorkspacePerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveDescriptor perspectiveDescriptorWithId = workbench.getPerspectiveRegistry().findPerspectiveWithId("com.modeliosoft.modelio.app.workspacePerspectiveID");
        if (perspectiveDescriptorWithId != null) {
            try {
                workbench.showPerspective(perspectiveDescriptorWithId.getId(), workbench.getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        }
    }

    private void switchToProjectPerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveDescriptor perspectiveDescriptorWithId = workbench.getPerspectiveRegistry().findPerspectiveWithId("com.modeliosoft.modelio.app.allViewsPerspectiveID");
        if (perspectiveDescriptorWithId != null) {
            try {
                workbench.showPerspective(perspectiveDescriptorWithId.getId(), workbench.getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        }
    }
}

