/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.services.migration;

import com.modeliosoft.modelio.core.IBase;
import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.core.app.AppInfos;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio10.ProjectMigrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio7005.Project7005Migrator;
import com.modeliosoft.modelio.internal.app.impl.migration.modelio7006.Project7006Migrator;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ProjectMigratorTool
implements IRunnableWithProgress {
    private File oldOfpPath;
    private File newOfpPath;
    private File projectDirectory;

    public ProjectMigratorTool(File projectDirectory, File ofpToMigrate, File projectOfpFile) {
        this.oldOfpPath = ofpToMigrate;
        this.newOfpPath = projectOfpFile;
        this.projectDirectory = projectDirectory;
    }

    public void execute(IProgressMonitor monitor) throws IOException {
        int mmVersion;
        OfpFile ofp = new OfpFile(this.oldOfpPath);
        int baseVersion = ofp.getMetamodelVersion();
        if (baseVersion > (mmVersion = AppInfos.getMetamodelVersion())) {
            throw new IOException(Messages.getMessage((String)"Migration.ModelioTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
        if (baseVersion < 6000) {
            throw new IOException(Messages.getMessage((String)"Migration.ProjectTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
        if (baseVersion < 7000) {
            throw new IOException(Messages.getMessage((String)"Migration.ProjectTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
        if (baseVersion <= 7004) {
            new ProjectMigrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion == 7005) {
            new Project7005Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion == 7006) {
            new Project7006Migrator(this.projectDirectory, this.oldOfpPath, this.newOfpPath).execute(monitor);
        } else if (baseVersion != mmVersion) {
            throw new IOException(Messages.getMessage((String)"Migration.ProjectTooOld", (String[])new String[]{this.oldOfpPath.getName(), String.valueOf(baseVersion), String.valueOf(mmVersion)}));
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.execute(monitor);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }

    public static boolean isMigrationRequired(IBase base) throws IOException {
        return com.modeliosoft.modelio.internal.app.impl.migration.ProjectMigrator.isMigrationRequired((IBase)base);
    }

    public static boolean isMigrationSupported(IBase base) throws IOException {
        return com.modeliosoft.modelio.internal.app.impl.migration.ProjectMigrator.isMigrationSupported((IBase)base);
    }
}

