/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.services.modules;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.internal.app.services.modules.ModulesUpdater;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.LocalModuleCreator;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.MdacDeployer;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveRepository;
import com.modeliosoft.modelio.mdainfra.mdacs.store.ModuleArchiveSorter;
import com.modeliosoft.modelio.mdainfra.mdacs.store.UnresolvedReferenceException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ModulesUpdater
implements IRunnableWithProgress {
    private IModelingSession session;
    private MdacArchiveRepository mdastore;
    private static final String RENAMED_MODULES_FILE = "res/common/update/renamed_modules.properties";
    private static final String HADES_CORE_PLUGIN_ID = "org.modelio.core";
    private Properties renamedModules;
    private final StringBuilder report = new StringBuilder();

    public ModulesUpdater(IModelingSession session) {
        this.session = session;
        File mdacStoreDir = new File(Platform.getInstallLocation().getURL().getPath(), "mdastore");
        LOG.info((String)"org.modelio.app.internal", (String)("Updating modules from " + mdacStoreDir.getPath()));
        this.mdastore = new MdacArchiveRepository(mdacStoreDir);
        this.initRenamedModules();
    }

    public void run(IProgressMonitor globalProgress) {
        MdacManager mdacManager = new MdacManager(this.session);
        ModuleDependencies deps = this.computeModuleDependencies();
        this.session.getAccessManager().setUser(0);
        ITransaction t = null;
        try {
            try {
                t = this.session.getTransactionManager().createTransaction("Update modules");
                for (IModule mdacModel : deps.disabledMdacs) {
                    mdacManager.deactivate(mdacModel);
                }
                MdacArchiveInfo coreModule = this.mdastore.getLatestVersion("ModelerModule");
                if (coreModule != null && !deps.mdacToDeploy.contains(coreModule)) {
                    deps.mdacToDeploy.add(coreModule);
                }
                List orderedModules = ModuleArchiveSorter.sort((Collection)deps.mdacToDeploy);
                this.deployModules(globalProgress, mdacManager, orderedModules);
                LocalModuleCreator c = new LocalModuleCreator(this.session);
                c.execute();
                this.session.getTransactionManager().commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                t = null;
                if (t != null) {
                    try {
                        this.session.getTransactionManager().rollback(t);
                    }
                    catch (Exception e2) {
                        this.report.append("---- couldn't rollback transaction ----");
                        this.reportStackTrace((Throwable)e2);
                        this.report.append("---------------------------------------");
                    }
                }
                this.session.getAccessManager().setUser(1);
            }
        }
        finally {
            if (t != null) {
                try {
                    this.session.getTransactionManager().rollback(t);
                }
                catch (Exception e) {
                    this.report.append("---- couldn't rollback transaction ----");
                    this.reportStackTrace((Throwable)e);
                    this.report.append("---------------------------------------");
                }
            }
            this.session.getAccessManager().setUser(1);
        }
    }

    private void computeDependencies(IModule mdacModel, Collection<String> localModules, ModuleDependencies deps) throws NumberFormatException {
        String name = mdacModel.getName();
        Version version = new Version(mdacModel.getVersion());
        MdacArchiveInfo archivedMdac = this.mdastore.getLatestVersion(name);
        if (archivedMdac == null) {
            archivedMdac = this.getLatestReplacementModule(name);
        }
        if (archivedMdac == null) {
            this.report.append("Cannot update ");
            this.report.append(name);
            this.report.append(" V");
            this.report.append(version.toString());
            this.report.append(" module : no archive has been found.");
            this.report.append("\n");
            deps.disabledMdacs.add(mdacModel);
            deps.incompatibleMdacs.add(mdacModel);
        } else {
            deps.mdacToDeploy.add(archivedMdac);
            try {
                for (MdacArchiveInfo needed : this.mdastore.getRequiredMdacs(archivedMdac)) {
                    if (localModules.contains(needed.siteIdentifier)) continue;
                    deps.mdacToDeploy.add(needed);
                }
            }
            catch (UnresolvedReferenceException e) {
                this.report.append("Cannot update ");
                this.report.append(name);
                this.report.append(" V");
                this.report.append(version.toString());
                this.report.append(" module :");
                this.report.append(e.getLocalizedMessage());
                this.report.append("\n");
                deps.disabledMdacs.add(mdacModel);
                deps.missingMdacs.addAll(e.getMissingReferences());
            }
        }
    }

    private ModuleDependencies computeModuleDependencies() throws NumberFormatException {
        ModuleDependencies deps = new ModuleDependencies();
        boolean migrateAll = true;
        HashSet<String> localModules = new HashSet<String>();
        for (IModule mdacModel : this.session.getModel().getProject().getInstalled()) {
            if (mdacModel.getElementStatus().isRamcObject()) {
                migrateAll = false;
                continue;
            }
            localModules.add(mdacModel.getIdentifier());
        }
        for (IModule mdacModel : this.session.getModel().getProject().getInstalled()) {
            if (!migrateAll && !mdacModel.getElementStatus().isRamcObject()) continue;
            this.computeDependencies(mdacModel, localModules, deps);
            this.refreshDisplay();
        }
        return deps;
    }

    private void deployModules(IProgressMonitor globalProgress, MdacManager mdacManager, List<MdacArchiveInfo> orderedModules) {
        SubProgressMonitor progress = new SubProgressMonitor(globalProgress, 1);
        progress.beginTask("", orderedModules.size());
        MdacDeployer deployer = new MdacDeployer(this.session, (IMdacManager)mdacManager);
        for (MdacArchiveInfo archivedMdac : orderedModules) {
            progress.subTask("Deploying " + archivedMdac.name + " " + archivedMdac.version);
            this.refreshDisplay();
            try {
                deployer.setStartModuleAtInstall(false);
                ArrayList<File> archiveFiles = new ArrayList<File>();
                archiveFiles.add(archivedMdac.getArchive().getPath());
                deployer.deployMdacs(archiveFiles, (IProgressMonitor)progress);
            }
            catch (MdacException e) {
                e.printStackTrace();
                this.report.append(e.getLocalizedMessage());
                this.report.append("\n");
            }
            catch (Error e) {
                this.reportStackTrace((Throwable)e);
            }
            catch (Exception e) {
                this.reportStackTrace((Throwable)e);
            }
            progress.worked(1);
        }
    }

    private MdacArchiveInfo getLatestReplacementModule(String name) {
        String newName = this.renamedModules.getProperty(name, null);
        if (newName == null) {
            return null;
        }
        return this.mdastore.getLatestVersion(newName);
    }

    private void initRenamedModules() {
        try {
            Bundle coreBundle = Platform.getBundle((String)HADES_CORE_PLUGIN_ID);
            Path path = new Path(RENAMED_MODULES_FILE);
            this.renamedModules = new Properties();
            this.renamedModules.load(FileLocator.openStream((Bundle)coreBundle, (IPath)path, (boolean)false));
        }
        catch (IOException e) {
            this.reportStackTrace((Throwable)e);
        }
    }

    private void reportStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.report.append(sw.toString());
        this.report.append("\n");
    }

    public String getReport() {
        return this.report.toString();
    }

    private void refreshDisplay() {
        Display.getCurrent().readAndDispatch();
    }
}

